/*
 * Decompiled with CFR 0.152.
 */
package net.witixin.armoreablemobs;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.witixin.armoreablemobs.CommonClass;
import net.witixin.armoreablemobs.Utilities;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.armoreablemobs.ArmorGroup")
@Document(value="mods/ArmoreableMobs/ArmorGroup")
public class ArmorGroup {
    private String name;
    private final Map<EquipmentSlot, ItemStack> slotItemStackMap = new HashMap<EquipmentSlot, ItemStack>();
    private List<String> stageList;
    private double weight;
    private String packmode;
    public static Map<EntityType, Map<EquipmentSlot, IItemStack>> overrideArmorGroups = new HashMap<EntityType, Map<EquipmentSlot, IItemStack>>();

    @ZenCodeType.Constructor
    public ArmorGroup(String name) {
        this.name = name;
        this.stageList = new ArrayList<String>();
        this.packmode = "";
        this.weight = 1.0;
    }

    public ArmorGroup(Iterator<ItemStack> iterator, ItemStack mainhand, ItemStack offhand) {
        this.slotItemStackMap.put(EquipmentSlot.HEAD, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.CHEST, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.LEGS, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.FEET, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.MAINHAND, mainhand);
        this.slotItemStackMap.put(EquipmentSlot.OFFHAND, offhand);
        this.name = "DummyGroup";
    }

    public ArmorGroup(Iterator<ItemStack> iterator) {
        this.slotItemStackMap.put(EquipmentSlot.HEAD, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.CHEST, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.LEGS, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.FEET, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.MAINHAND, iterator.next());
        this.slotItemStackMap.put(EquipmentSlot.OFFHAND, iterator.next());
    }

    @ZenCodeType.Method
    public ArmorGroup setWeight(double weight) {
        this.weight = weight;
        return this;
    }

    @ZenCodeType.Method
    public ArmorGroup inSlot(EquipmentSlot slot, IItemStack stack) {
        this.slotItemStackMap.put(slot, stack.getInternal());
        return this;
    }

    @ZenCodeType.Method
    public void register(EntityType type) {
        CommonClass.armorList.put(type, Utilities.mergeOrMakeList(CommonClass.armorList.get(type), this));
        CraftTweakerAPI.LOGGER.info("Registered new ArmorGroup for entity: " + EntityType.m_20613_((EntityType)type).toString() + " under the name: " + this.getName());
    }

    @ZenCodeType.Method
    public Map<EquipmentSlot, ItemStack> getMap() {
        return this.slotItemStackMap;
    }

    @ZenCodeType.Method
    public List<String> getStages() {
        return this.stageList;
    }

    public String getPackmode() {
        return this.packmode;
    }

    @ZenCodeType.Method
    public ArmorGroup addStages(String ... stages) {
        if (Services.PLATFORM.getPlatformName().equals("Forge")) {
            this.stageList.addAll(Arrays.asList(stages));
        } else {
            CraftTweakerAPI.LOGGER.warn("Forge only method (ArmorGroup#addStages) was run on a Fabric Platform! This will not do anything!");
        }
        return this;
    }

    @ZenCodeType.Method
    public double getWeight() {
        return this.weight;
    }

    @ZenCodeType.Method
    public String getName() {
        return this.name;
    }

    @ZenCodeType.Method
    public ItemStack getStackInSlot(EquipmentSlot slot) {
        return this.slotItemStackMap.get(slot);
    }

    @ZenCodeType.Caster(implicit=true)
    public String toString() {
        return this.name;
    }

    @ZenCodeType.Method
    public static void overrideExistingArmor(EntityType type, Map<EquipmentSlot, IItemStack> map, @ZenCodeType.Optional BlockState state) {
        if (state == null) {
            overrideArmorGroups.put(type, map);
        } else {
            ArmorGroup.addBlockOverrides(type, state, map);
        }
    }

    private static void addBlockOverrides(EntityType type, BlockState state, Map<EquipmentSlot, IItemStack> map) {
        CommonClass.entityBlockStateMapOverrides.put(type, state);
        CommonClass.blockstateArmorOverries.put(state, map);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ArmorGroup ag = (ArmorGroup)obj;
        return this.slotItemStackMap.equals(ag.slotItemStackMap);
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.slotItemStackMap.values()) {
            if (stack == ItemStack.f_41583_) continue;
            return false;
        }
        return true;
    }
}

