/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_stronghold.world.structures;

import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.world.structures.AdvancedDistanceJigsawStructure;
import com.craisinlord.integrated_api.world.structures.configs.AdvancedDistanceConfig;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class StrongholdStructure<C extends AdvancedDistanceConfig>
extends AdvancedDistanceJigsawStructure<C> {
    public StrongholdStructure(Codec<C> codec) {
        super(codec, StrongholdStructure::isStrongholdFeatureChunk, AdvancedDistanceJigsawStructure::generateDistancePieces);
    }

    protected static <CC extends AdvancedDistanceConfig> boolean isStrongholdFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        boolean superCheck = AdvancedDistanceJigsawStructure.isDistanceFeatureChunk(context);
        if (!superCheck) {
            return false;
        }
        ChunkPos chunkPos = context.f_197355_();
        int minLandHeight = Math.min(GeneralUtils.getMaxTerrainLimit((ChunkGenerator)context.f_197352_()), context.f_197352_().m_142062_() + 45);
        int xPos = chunkPos.m_45604_();
        int zPos = chunkPos.m_45605_();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.m_122432_();
                offsetPos.m_122261_(35.0f * (float)i);
                landHeight = StrongholdStructure.getHeightAt(context.f_197352_(), context.f_197357_(), xPos + (int)offsetPos.m_122239_(), zPos + (int)offsetPos.m_122269_(), landHeight);
                if (landHeight >= minLandHeight) continue;
                return false;
            }
        }
        landHeight = StrongholdStructure.getHeightAt(context.f_197352_(), context.f_197357_(), xPos, zPos, landHeight);
        return landHeight >= minLandHeight;
    }

    private static int getHeightAt(ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, chunkGenerator.m_156179_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView));
        return landHeight;
    }
}

