/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import fuzs.puzzleslib.api.core.v1.ForgeDistTypeConverter;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandlerForgeV2
implements NetworkHandlerV2 {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final AtomicInteger discriminator = new AtomicInteger();
    private final SimpleChannel channel;
    public final boolean clientAcceptsVanillaOrMissing;
    public final boolean serverAcceptsVanillaOrMissing;

    public NetworkHandlerForgeV2(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        this.channel = NetworkHandlerForgeV2.buildSimpleChannel(modId, clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing);
        this.clientAcceptsVanillaOrMissing = clientAcceptsVanillaOrMissing;
        this.serverAcceptsVanillaOrMissing = serverAcceptsVanillaOrMissing;
    }

    @Override
    public <T extends MessageV2<T>> void register(Class<? extends T> clazz, Supplier<T> factory, MessageDirection direction) {
        BiConsumer<MessageV2, FriendlyByteBuf> encode = MessageV2::write;
        Function<FriendlyByteBuf, MessageV2> decode = buf -> {
            MessageV2 message = (MessageV2)factory.get();
            message.read((FriendlyByteBuf)buf);
            return message;
        };
        BiConsumer<MessageV2, Supplier> handle = (message, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            LogicalSide receptionSide = ForgeDistTypeConverter.toLogicalSide(direction.getReceptionSide());
            LogicalSide expectedReceptionSide = context.getDirection().getReceptionSide();
            if (expectedReceptionSide != receptionSide) {
                throw new IllegalStateException(String.format("Received message on wrong side, expected %s, was %s", receptionSide, expectedReceptionSide));
            }
            context.enqueueWork(() -> {
                Object player = receptionSide.isClient() ? Proxy.INSTANCE.getClientPlayer() : context.getSender();
                message.makeHandler().handle((MessageV2)message, (Player)player, LogicalSidedProvider.WORKQUEUE.get(receptionSide));
            });
            context.setPacketHandled(true);
        };
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, encode, decode, handle);
    }

    @Override
    public Packet<ServerGamePacketListener> toServerboundPacket(MessageV2<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public Packet<ClientGamePacketListener> toClientboundPacket(MessageV2<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static SimpleChannel buildSimpleChannel(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
    }
}

