/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BiomeModificationsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BuildCreativeModeTabContentsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.CreativeModeTabContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.DataPackSourcesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesCreateContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesModifyContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FlammableBlocksContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FuelBurnTimesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.SpawnPlacementsContextForgeImpl;
import fuzs.puzzleslib.impl.item.CopyTagRecipe;
import fuzs.puzzleslib.impl.item.ForgeCopyTagRecipeSerializer;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeModConstructor {
    private ForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ModContainerHelper.findModEventBus(modId).ifPresent(modEventBus -> {
            ForgeModConstructor.registerContent(constructor, modId, modEventBus, flagsToHandle);
            ForgeModConstructor.registerModHandlers(constructor, modEventBus, availableFlags);
            ForgeModConstructor.registerHandlers(constructor);
            constructor.onConstructMod();
        });
    }

    private static void registerContent(ModConstructor constructor, String modId, IEventBus modEventBus, Set<ContentRegistrationFlags> flagsToHandle) {
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_TAG_RECIPES)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.RECIPE_SERIALIZERS, (String)modId);
            deferredRegister.register(modEventBus);
            if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_TAG_RECIPES)) {
                CopyTagRecipe.registerSerializers((arg_0, arg_1) -> ((DeferredRegister)deferredRegister).register(arg_0, arg_1), ForgeCopyTagRecipeSerializer::new);
            }
        }
    }

    private static void registerModHandlers(ModConstructor constructor, IEventBus eventBus, Set<ContentRegistrationFlags> availableFlags) {
        eventBus.addGenericListener(Fluid.class, evt -> {
            constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextForgeImpl());
            constructor.onBuildCreativeModeTabContents(new BuildCreativeModeTabContentsContextForgeImpl());
        });
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onCommonSetup();
            constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextForgeImpl());
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextForgeImpl(availableFlags));
            constructor.onRegisterFlammableBlocks(new FlammableBlocksContextForgeImpl());
            constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextForgeImpl());
        }));
        eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.SERVER_DATA) {
                constructor.onAddDataPackFinders(new DataPackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
            }
        });
    }

    private static void registerHandlers(ModConstructor constructor) {
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterDataPackReloadListeners(new AddReloadListenersContextForgeImpl(arg_0 -> ((AddReloadListenerEvent)evt).addListener(arg_0))));
    }
}

