/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nullable;

public class ReflectionHelper {
    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Optional<T> get(@Nullable Field field, Object instance) {
        if (field != null) {
            try {
                return Optional.of(field.get(instance));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static <T> Optional<T> invoke(@Nullable Method method, Object instance, Object ... args) {
        if (method != null) {
            try {
                return Optional.ofNullable(method.invoke(instance, args));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static <T> Optional<T> newInstance(@Nullable Constructor<T> constructor, Object ... args) {
        if (constructor != null) {
            try {
                return Optional.of(constructor.newInstance(args));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

