/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolderImpl;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public interface ConfigHolder<C extends AbstractConfig, S extends AbstractConfig> {
    public C client();

    public S server();

    public boolean isClientAvailable();

    public boolean isServerAvailable();

    public void addClientCallback(Runnable var1);

    public void addServerCallback(Runnable var1);

    public static String simpleName(String modId) {
        return String.format("%s.toml", modId);
    }

    public static String defaultName(String modId, ModConfig.Type type) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String moveToDir(String configDir, String fileName) {
        return Paths.get(configDir, fileName).toString();
    }

    public static <C extends AbstractConfig, S extends AbstractConfig> ConfigHolderImpl<C, S> of(Supplier<C> client, Supplier<S> server) {
        return new ConfigHolderImpl<C, S>(client, server);
    }

    public static <C extends AbstractConfig> ConfigHolderImpl<C, AbstractConfig> client(Supplier<C> client) {
        return new ConfigHolderImpl<C, AbstractConfig>(client, () -> null);
    }

    public static <S extends AbstractConfig> ConfigHolderImpl<AbstractConfig, S> server(Supplier<S> server) {
        return new ConfigHolderImpl<AbstractConfig, S>(() -> null, server);
    }

    @FunctionalInterface
    public static interface ConfigCallback {
        public <T> void accept(ForgeConfigSpec.ConfigValue<T> var1, Consumer<T> var2);
    }
}

