/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import com.mojang.bridge.game.GameVersion;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModPackResources
implements PackResources {
    private String logoModId;
    private final String modLogoPath;
    private String id;
    private PackMetadataSection metadata;

    protected AbstractModPackResources() {
        this(null);
    }

    protected AbstractModPackResources(@Nullable String logoModId) {
        this(logoModId, "mod_logo.png");
    }

    protected AbstractModPackResources(@Nullable String logoModId, String modLogoPath) {
        this.logoModId = logoModId;
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public InputStream m_5542_(String string) throws IOException {
        Optional<Path> optional;
        if ("pack.png".equals(string) && (optional = ModLoaderEnvironment.INSTANCE.findModResource(this.logoModId, this.modLogoPath)).isPresent()) {
            return Files.newInputStream(optional.get(), new OpenOption[0]);
        }
        return null;
    }

    public Collection<ResourceLocation> m_7466_(PackType packType, String string, String string2, int i, Predicate<String> predicate) {
        return Collections.emptyList();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        return (T)(deserializer == PackMetadataSection.f_10366_ ? this.metadata : null);
    }

    public String m_8017_() {
        return this.id;
    }

    public void close() {
    }

    @ApiStatus.Internal
    static Pack buildPack(PackType packType, Supplier<AbstractModPackResources> factory, String id, Component title, Component description, boolean required, boolean fixedPosition) {
        PackMetadataSection metadata = new PackMetadataSection(description, packType.m_143756_((GameVersion)SharedConstants.m_183709_()));
        return new Pack(id, required, () -> {
            AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
            packResources.id = id;
            packResources.metadata = metadata;
            if (packResources.logoModId == null) {
                packResources.logoModId = id;
            }
            return packResources;
        }, title, description, PackCompatibility.COMPATIBLE, Pack.Position.TOP, fixedPosition, PackSource.f_10528_);
    }
}

