/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public final class AbstractTagProvider {

    public static interface TagProviderExtension<T> {
        public Registry<T> registry();

        default public ResourceKey<? extends Registry<T>> registryKey() {
            return (ResourceKey)Registry.f_122897_.m_7854_(this.registry()).or(() -> BuiltinRegistries.f_123858_.m_7854_(this.registry())).orElseThrow();
        }

        public TagsProvider.TagAppender<T> m_206424_(TagKey<T> var1);

        default public TagsProvider.TagAppender<T> tag(String resourceLocation) {
            return this.tag(new ResourceLocation(resourceLocation));
        }

        default public TagsProvider.TagAppender<T> tag(ResourceLocation resourceLocation) {
            return this.m_206424_(TagKey.m_203882_(this.registryKey(), (ResourceLocation)resourceLocation));
        }
    }

    public static abstract class Simple<T>
    extends TagsProvider<T>
    implements TagProviderExtension<T> {
        public Simple(Registry<T> registryKey, GatherDataEvent evt, String modId) {
            this(registryKey, evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public Simple(Registry<T> registryKey, DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            super(packOutput, registryKey, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public Simple(DataGenerator packOutput, Registry<T> registryKey, String modId, ExistingFileHelper fileHelper) {
            this(registryKey, packOutput, fileHelper, modId);
        }

        protected abstract void m_6577_();

        public final String m_6055_() {
            return "Tags for " + this.registryKey().m_135782_();
        }

        @Override
        public Registry<T> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<T> m_206424_(TagKey<T> tagKey) {
            return super.m_206424_(tagKey);
        }
    }

    public static abstract class GameEvents
    extends GameEventTagsProvider
    implements TagProviderExtension<GameEvent> {
        public GameEvents(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public GameEvents(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            super(packOutput, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public GameEvents(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId);
        }

        protected abstract void m_6577_();

        @Override
        public Registry<GameEvent> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<GameEvent> m_206424_(TagKey<GameEvent> tagKey) {
            return super.m_206424_(tagKey);
        }
    }

    public static abstract class EntityTypes
    extends EntityTypeTagsProvider
    implements TagProviderExtension<EntityType<?>> {
        public EntityTypes(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public EntityTypes(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            super(packOutput, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public EntityTypes(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId);
        }

        protected abstract void m_6577_();

        @Override
        public Registry<EntityType<?>> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<EntityType<?>> m_206424_(TagKey<EntityType<?>> tagKey) {
            return super.m_206424_(tagKey);
        }
    }

    public static abstract class Items
    extends ItemTagsProvider
    implements TagProviderExtension<Item> {
        public Items(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public Items(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            this(packOutput, fileHelper, modId, new BlockTagsProvider(packOutput, modId, fileHelper){

                protected void m_6577_() {
                }
            });
        }

        public Items(GatherDataEvent evt, String modId, BlockTagsProvider blockTagsProvider) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId, blockTagsProvider);
        }

        public Items(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId, BlockTagsProvider blockTagsProvider) {
            super(packOutput, blockTagsProvider, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public Items(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId);
        }

        @Deprecated(forRemoval=true)
        public Items(DataGenerator packOutput, BlockTagsProvider blockTagsProvider, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId, blockTagsProvider);
        }

        protected abstract void m_6577_();

        @Deprecated
        protected void m_206421_(TagKey<Block> blockTagKey, TagKey<Item> itemTagKey) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Registry<Item> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<Item> m_206424_(TagKey<Item> tagKey) {
            return super.m_206424_(tagKey);
        }
    }

    public static abstract class Fluids
    extends FluidTagsProvider
    implements TagProviderExtension<Fluid> {
        public Fluids(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public Fluids(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            super(packOutput, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public Fluids(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId);
        }

        protected abstract void m_6577_();

        @Override
        public Registry<Fluid> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<Fluid> m_206424_(TagKey<Fluid> tagKey) {
            return super.m_206424_(tagKey);
        }
    }

    public static abstract class Blocks
    extends BlockTagsProvider
    implements TagProviderExtension<Block> {
        public Blocks(GatherDataEvent evt, String modId) {
            this(evt.getGenerator(), evt.getExistingFileHelper(), modId);
        }

        public Blocks(DataGenerator packOutput, ExistingFileHelper fileHelper, String modId) {
            super(packOutput, modId, fileHelper);
        }

        @Deprecated(forRemoval=true)
        public Blocks(DataGenerator packOutput, String modId, ExistingFileHelper fileHelper) {
            this(packOutput, fileHelper, modId);
        }

        protected abstract void m_6577_();

        @Override
        public Registry<Block> registry() {
            return this.f_126540_;
        }

        @Override
        public TagsProvider.TagAppender<Block> m_206424_(TagKey<Block> tagKey) {
            return super.m_206424_(tagKey);
        }
    }
}

