/*
 * Decompiled with CFR 0.152.
 */
package fuzs.nightconfigfixes.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import fuzs.nightconfigfixes.NightConfigFixes;
import fuzs.nightconfigfixes.config.CheckedConfigFileTypeHandler;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.fml.loading.FMLPaths;

public class NightConfigFixesConfig {
    public static final NightConfigFixesConfig INSTANCE;
    private static final String CONFIG_FILE_NAME = "nightconfigfixes.toml";
    private static final Map<String, Object> CONFIG_VALUES;
    private static final ConfigSpec CONFIG_SPEC;
    private CommentedFileConfig configData;

    private NightConfigFixesConfig() {
        this.loadFrom(FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_NAME));
    }

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile, (ConfigFormat)TomlFormat.instance()).sync().onFileNotFound(FileNotFoundAction.copyData((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/nightconfigfixes.toml")))).autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        try {
            CheckedConfigFileTypeHandler.tryLoadConfigFile((FileConfig)this.configData);
        }
        catch (ParsingException e) {
            throw new RuntimeException("Failed to load %s config from %s".formatted("Night Config Fixes", configFile), e);
        }
        if (!CONFIG_SPEC.isCorrect((Config)this.configData)) {
            NightConfigFixes.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configFile);
            CONFIG_SPEC.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> NightConfigFixes.LOGGER.warn("Incorrect key {} was corrected from {} to {}", (Object)path, incorrectValue, correctedValue));
        }
        this.configData.save();
    }

    public <T> T getValue(String key) {
        if (!CONFIG_VALUES.containsKey(key)) {
            throw new IllegalArgumentException("%s is not a know config value key".formatted(key));
        }
        Object value = this.configData.get(key);
        if (value != null) {
            return (T)value;
        }
        NightConfigFixes.LOGGER.warn("Configuration file {} is not correct. Using default setting for key {}", (Object)FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_NAME), (Object)key);
        return (T)CONFIG_VALUES.get(key);
    }

    static {
        CONFIG_VALUES = ImmutableMap.builder().put((Object)"forceGlobalServerConfigs", (Object)false).put((Object)"recreateConfigsWhenParsingFails", (Object)true).put((Object)"correctConfigValuesFromDefaultConfig", (Object)true).build();
        CONFIG_SPEC = new ConfigSpec();
        for (Map.Entry<String, Object> entry : CONFIG_VALUES.entrySet()) {
            CONFIG_SPEC.define(entry.getKey(), entry.getValue());
        }
        INSTANCE = new NightConfigFixesConfig();
    }
}

