/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.forge;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.ClientSetup;
import com.cursedcauldron.wildbackport.common.CommonSetup;
import com.cursedcauldron.wildbackport.common.registry.WBBiomes;
import com.cursedcauldron.wildbackport.common.worldgen.MangroveSwampSurface;
import com.cursedcauldron.wildbackport.core.api.forge.EventBuses;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="wildbackport")
public class WildBackportForge {
    public WildBackportForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus("wildbackport", bus);
        bus.addListener(event -> CommonSetup.onPostCommon());
        bus.addListener(event -> ClientSetup.onPostClient());
        bus.addListener(this::terrablenderSetup);
        WildBackport.bootstrap();
        CommonSetup.onCommon();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::onClient);
    }

    private void terrablenderSetup(FMLCommonSetupEvent event) {
        Regions.register((Region)new Region(new ResourceLocation("wildbackport", "overworld"), RegionType.OVERWORLD, 2){

            public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
                this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
                    builder.replaceBiome(Biomes.f_48207_, WBBiomes.MANGROVE_SWAMP);
                    List points = new ParameterUtils.ParameterPointListBuilder().erosion(new Climate.Parameter[]{ParameterUtils.Erosion.span((ParameterUtils.Erosion)ParameterUtils.Erosion.EROSION_0, (ParameterUtils.Erosion)ParameterUtils.Erosion.EROSION_1)}).depth(new Climate.Parameter[]{Climate.Parameter.m_186820_((float)1.1f)}).build();
                    points.forEach(point -> mapper.accept(Pair.of((Object)point, WBBiomes.DEEP_DARK)));
                });
            }
        });
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"wildbackport", (SurfaceRules.RuleSource)MangroveSwampSurface.makeRules());
    }
}

