/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.forge;

import com.cursedcauldron.wildbackport.common.effects.EffectFactor;
import com.cursedcauldron.wildbackport.common.registry.WBMobEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wildbackport", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DarknessSetup {
    @SubscribeEvent
    public static void darknessFogColor(EntityViewRenderEvent.FogColors event) {
        FogType type = event.getCamera().m_167685_();
        Level level = event.getCamera().m_90592_().m_183503_();
        if (level.m_5776_() && level instanceof ClientLevel) {
            MobEffectInstance effect;
            LivingEntity living;
            ClientLevel client = (ClientLevel)level;
            double colorModifier = (event.getCamera().m_90583_().f_82480_ - (double)client.m_141937_()) * (double)client.m_6106_().m_205519_();
            Entity entity = event.getCamera().m_90592_();
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(WBMobEffects.DARKNESS.get()) && (effect = living.m_21124_(WBMobEffects.DARKNESS.get())) != null) {
                EffectFactor.Instance instance = EffectFactor.Instance.of(effect);
                colorModifier = instance.getFactorCalculationData().isPresent() ? (double)(1.0f - instance.getFactorCalculationData().get().lerp(living, (float)event.getPartialTicks())) : 0.0;
            }
            if (colorModifier < 1.0 && type != FogType.LAVA) {
                if (colorModifier < 0.0) {
                    colorModifier = 0.0;
                }
                colorModifier *= colorModifier;
                event.setRed((float)((double)event.getRed() * colorModifier));
                event.setGreen((float)((double)event.getGreen() * colorModifier));
                event.setBlue((float)((double)event.getBlue() * colorModifier));
            }
        }
    }

    @SubscribeEvent
    public static void darknessFog(EntityViewRenderEvent.RenderFogEvent event) {
        EffectFactor.Instance instance;
        MobEffectInstance effect;
        LivingEntity living;
        Entity entity;
        FogType type = event.getCamera().m_167685_();
        if (type != FogType.WATER && (entity = event.getCamera().m_90592_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(WBMobEffects.DARKNESS.get()) && (effect = living.m_21124_(WBMobEffects.DARKNESS.get())) != null && (instance = EffectFactor.Instance.of(effect)).getFactorCalculationData().isPresent()) {
            float modifier = Mth.m_14179_((float)instance.getFactorCalculationData().get().lerp(living, (float)event.getPartialTicks()), (float)event.getFarPlaneDistance(), (float)15.0f);
            float start = event.getMode() == FogRenderer.FogMode.FOG_SKY ? 0.0f : modifier * 0.75f;
            RenderSystem.m_157445_((float)start);
            RenderSystem.m_157443_((float)modifier);
        }
    }
}

