/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.mixin.client;

import com.cursedcauldron.wildbackport.common.effects.EffectFactor;
import com.cursedcauldron.wildbackport.common.registry.WBMobEffects;
import com.cursedcauldron.wildbackport.core.api.Environment;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin {
    @Shadow
    @Final
    private Minecraft f_109876_;
    @Shadow
    private boolean f_109873_;
    @Shadow
    private float f_109874_;
    @Shadow
    @Final
    private DynamicTexture f_109870_;
    @Shadow
    @Final
    private NativeImage f_109871_;
    @Shadow
    @Final
    private GameRenderer f_109875_;

    @Shadow
    protected abstract float m_109888_(Level var1, int var2);

    private LocalPlayer getPlayer() {
        return this.f_109876_.f_91074_;
    }

    private float getDarknessFactor(float delta) {
        MobEffectInstance instance = this.getPlayer().m_21124_(WBMobEffects.DARKNESS.get());
        if (this.getPlayer().m_21023_(WBMobEffects.DARKNESS.get()) && instance != null && EffectFactor.Instance.of(instance).getFactorCalculationData().isPresent()) {
            return EffectFactor.Instance.of(instance).getFactorCalculationData().get().lerp((LivingEntity)this.getPlayer(), delta);
        }
        return 0.0f;
    }

    private float getDarkness(LivingEntity entity, float factor, float delta) {
        return Math.max(0.0f, Mth.m_14089_((float)(((float)entity.f_19797_ - delta) * (float)Math.PI * 0.025f)) * 0.45f * factor);
    }

    @Inject(method={"updateLightTexture(F)V"}, at={@At(value="HEAD")})
    private void updateLight(float delta, CallbackInfo ci) {
        if (Environment.isModLoaded("lod")) {
            return;
        }
        if (this.f_109873_) {
            this.f_109873_ = false;
            this.f_109876_.m_91307_().m_6180_("lightTex");
            ClientLevel level = this.f_109876_.f_91073_;
            if (level != null) {
                float skyDarken = level.m_104805_(1.0f);
                float skyFlashTime = level.m_104819_() > 0 ? 1.0f : skyDarken * 0.95f + 0.05f;
                float darknessFactor = this.getDarknessFactor(delta);
                float darkness = this.getDarkness((LivingEntity)this.getPlayer(), darknessFactor, delta);
                float waterVision = this.getPlayer().m_108639_();
                float visionScale = this.getPlayer().m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)this.getPlayer(), (float)delta) : (waterVision > 0.0f && this.getPlayer().m_21023_(MobEffects.f_19592_) ? waterVision : 0.0f);
                Vector3f vec3f = new Vector3f(skyDarken, skyDarken, 1.0f);
                vec3f.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                float blockLightFlicker = this.f_109874_ + 1.5f;
                Vector3f vec3f2 = new Vector3f();
                for (int skyLight = 0; skyLight < 16; ++skyLight) {
                    for (int blockLight = 0; blockLight < 16; ++blockLight) {
                        float modifier;
                        float skyBrightness = this.m_109888_((Level)level, skyLight) * skyFlashTime;
                        float blockBrightness = this.m_109888_((Level)level, blockLight) * blockLightFlicker;
                        float yLight = blockBrightness * ((blockBrightness * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float xzLight = blockBrightness * (blockBrightness * blockBrightness * 0.6f + 0.4f);
                        vec3f2.m_122245_(blockBrightness, yLight, xzLight);
                        boolean forceLightmap = level.m_104583_().m_108884_();
                        if (forceLightmap) {
                            vec3f2.m_122255_(new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                            vec3f2.m_122242_(0.0f, 1.0f);
                        } else {
                            Vector3f vec3f3 = vec3f.m_122281_();
                            vec3f3.m_122261_(skyBrightness);
                            vec3f2.m_122253_(vec3f3);
                            vec3f2.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.f_109875_.m_109131_(delta) > 0.0f) {
                                float darkenWorldAmount = this.f_109875_.m_109131_(delta);
                                Vector3f vec3f4 = vec3f2.m_122281_();
                                vec3f4.m_122263_(0.7f, 0.6f, 0.6f);
                                vec3f2.m_122255_(vec3f4, darkenWorldAmount);
                            }
                        }
                        if (visionScale > 0.0f && (modifier = Math.max(vec3f2.m_122239_(), Math.max(vec3f2.m_122260_(), vec3f2.m_122269_()))) < 1.0f) {
                            float scale = 1.0f / modifier;
                            Vector3f vec3f3 = vec3f2.m_122281_();
                            vec3f3.m_122261_(scale);
                            vec3f2.m_122255_(vec3f3, visionScale);
                        }
                        if (!forceLightmap) {
                            if (darkness > 0.0f) {
                                vec3f2.m_122272_(-darkness, -darkness, -darkness);
                            }
                            vec3f2.m_122242_(0.0f, 1.0f);
                        }
                        float gamma = (float)this.f_109876_.f_91066_.f_92071_;
                        Vector3f vec3f3 = vec3f2.m_122281_();
                        vec3f3.m_122258_(this::notGamma);
                        vec3f2.m_122255_(vec3f3, Math.max(0.0f, gamma - darknessFactor));
                        vec3f2.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        vec3f2.m_122242_(0.0f, 1.0f);
                        vec3f2.m_122261_(255.0f);
                        int x = (int)vec3f2.m_122239_();
                        int y = (int)vec3f2.m_122260_();
                        int z = (int)vec3f2.m_122269_();
                        this.f_109871_.m_84988_(blockLight, skyLight, 0xFF000000 | z << 16 | y << 8 | x);
                    }
                }
                this.f_109870_.m_117985_();
                this.f_109876_.m_91307_().m_7238_();
            }
        }
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }
}

