/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.cursedcauldron.wildbackport.common.worldgen.placers.UpwardBranchingTrunk;
import com.cursedcauldron.wildbackport.core.mixin.access.TreeFeatureAccessor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class RootedTreeFeature
extends Feature<RootedTreeConfig> {
    public RootedTreeFeature(Codec<RootedTreeConfig> codec) {
        super(codec);
    }

    private boolean generate(WorldGenLevel level, Random random, BlockPos pos, BiConsumer<BlockPos, BlockState> rootPlacerReplacer, BiConsumer<BlockPos, BlockState> trunkPlacerReplacer, BiConsumer<BlockPos, BlockState> foliagePlacerReplacer, RootedTreeConfig config) {
        int treeHeight = config.f_68190_.m_70309_(random);
        int foliageHeight = config.f_68189_.m_5969_(random, treeHeight, (TreeConfiguration)config);
        int trunkLength = treeHeight - foliageHeight;
        int foliageRadius = config.f_68189_.m_5937_(random, trunkLength);
        BlockPos origin = config.rootPlacer.map(rootPlacer -> rootPlacer.trunkOffset(pos, random)).orElse(pos);
        int minHeight = Math.min(pos.m_123342_(), origin.m_123342_());
        int maxHeight = Math.max(pos.m_123342_(), origin.m_123342_()) + treeHeight + 1;
        if (minHeight >= level.m_141937_() + 1 && maxHeight <= level.m_151558_()) {
            OptionalInt clippedHeight = config.f_68191_.m_68295_();
            int topPosition = this.getTopPosition((LevelSimulatedReader)level, treeHeight, origin, config);
            if (topPosition >= treeHeight || clippedHeight.isPresent() && topPosition >= clippedHeight.getAsInt()) {
                if (config.rootPlacer.isPresent() && !config.rootPlacer.get().generate((LevelSimulatedReader)level, rootPlacerReplacer, random, pos, origin, config)) {
                    return false;
                }
                List foliage = config.f_68190_.m_142625_((LevelSimulatedReader)level, trunkPlacerReplacer, random, topPosition, origin, (TreeConfiguration)config);
                foliage.forEach(node -> config.f_68189_.m_161413_((LevelSimulatedReader)level, foliagePlacerReplacer, random, (TreeConfiguration)config, topPosition, node, foliageHeight, foliageRadius));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getTopPosition(LevelSimulatedReader level, int height, BlockPos pos, RootedTreeConfig config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= height + 1; ++y) {
            int size = config.f_68191_.m_6133_(height, y);
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    UpwardBranchingTrunk trunk;
                    TrunkPlacer trunkPlacer;
                    boolean isValid;
                    mutable.m_122154_((Vec3i)pos, x, y, z);
                    boolean bl = isValid = TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos) || level.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_)) || (trunkPlacer = config.f_68190_) instanceof UpwardBranchingTrunk && level.m_7433_(pos, arg_0 -> RootedTreeFeature.lambda$getTopPosition$3(trunk = (UpwardBranchingTrunk)trunkPlacer, arg_0));
                    if (isValid && (config.f_68193_ || !TreeFeatureAccessor.isVine(level, (BlockPos)mutable))) continue;
                    return y - 2;
                }
            }
        }
        return height;
    }

    public final boolean m_142674_(FeaturePlaceContext<RootedTreeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        BlockPos pos = context.m_159777_();
        RootedTreeConfig config = (RootedTreeConfig)context.m_159778_();
        HashSet rootPos = Sets.newHashSet();
        HashSet trunkPos = Sets.newHashSet();
        HashSet foliagePos = Sets.newHashSet();
        HashSet decoratorPos = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> rootReplacer = (position, state) -> {
            rootPos.add(position.m_7949_());
            level.m_7731_(position, state, 19);
        };
        BiConsumer<BlockPos, BlockState> trunkReplacer = (position, state) -> {
            trunkPos.add(position.m_7949_());
            level.m_7731_(position, state, 19);
        };
        BiConsumer<BlockPos, BlockState> foliageReplacer = (position, state) -> {
            foliagePos.add(position.m_7949_());
            level.m_7731_(position, state, 19);
        };
        BiConsumer<BlockPos, BlockState> decoratorReplacer = (position, state) -> {
            decoratorPos.add(position.m_7949_());
            level.m_7731_(position, state, 19);
        };
        boolean generate = this.generate(level, random, pos, rootReplacer, trunkReplacer, foliageReplacer, config);
        if (!generate || trunkPos.isEmpty() && foliagePos.isEmpty()) {
            return false;
        }
        if (!config.f_68187_.isEmpty()) {
            ArrayList rootPositions = Lists.newArrayList((Iterable)rootPos);
            ArrayList trunkPositions = Lists.newArrayList((Iterable)trunkPos);
            ArrayList foliagePositions = Lists.newArrayList((Iterable)foliagePos);
            trunkPositions.sort(Comparator.comparingInt(Vec3i::m_123342_));
            foliagePositions.sort(Comparator.comparingInt(Vec3i::m_123342_));
            rootPositions.sort(Comparator.comparingInt(Vec3i::m_123342_));
            config.f_68187_.forEach(treeDecorator -> treeDecorator.m_142741_((LevelSimulatedReader)level, decoratorReplacer, random, (List)trunkPositions, (List)foliagePositions));
        }
        return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)trunkPos, (Iterable)foliagePos, (Iterable)decoratorPos)).map(box -> {
            DiscreteVoxelShape shape = RootedTreeFeature.placeLogsAndLeaves((LevelAccessor)level, box, trunkPos, decoratorPos);
            StructureTemplate.m_74510_((LevelAccessor)level, (int)3, (DiscreteVoxelShape)shape, (int)box.m_162395_(), (int)box.m_162396_(), (int)box.m_162398_());
            return true;
        }).orElse(false);
    }

    private static DiscreteVoxelShape placeLogsAndLeaves(LevelAccessor level, BoundingBox box, Set<BlockPos> trunkPositions, Set<BlockPos> decoratorPositions) {
        ArrayList positions = Lists.newArrayList();
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(box.m_71056_(), box.m_71057_(), box.m_71058_());
        for (int tries = 0; tries < 6; ++tries) {
            positions.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos pos : Lists.newArrayList(decoratorPositions)) {
            if (!box.m_71051_((Vec3i)pos)) continue;
            shape.m_142703_(pos.m_123341_() - box.m_162395_(), pos.m_123342_() - box.m_162396_(), pos.m_123343_() - box.m_162398_());
        }
        for (BlockPos pos : Lists.newArrayList(trunkPositions)) {
            if (box.m_71051_((Vec3i)pos)) {
                shape.m_142703_(pos.m_123341_() - box.m_162395_(), pos.m_123342_() - box.m_162396_(), pos.m_123343_() - box.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockState;
                mutable.m_122159_((Vec3i)pos, direction);
                if (trunkPositions.contains(mutable) || !(blockState = level.m_8055_((BlockPos)mutable)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)positions.get(0)).add(mutable.m_7949_());
                TreeFeatureAccessor.setBlockKnownShape((LevelWriter)level, (BlockPos)mutable, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!box.m_71051_((Vec3i)mutable)) continue;
                shape.m_142703_(mutable.m_123341_() - box.m_162395_(), mutable.m_123342_() - box.m_162396_(), mutable.m_123343_() - box.m_162398_());
            }
        }
        for (int tries = 1; tries < 6; ++tries) {
            Set trunkPos = (Set)positions.get(tries - 1);
            Set foliagePos = (Set)positions.get(tries);
            for (BlockPos pos : trunkPos) {
                if (box.m_71051_((Vec3i)pos)) {
                    shape.m_142703_(pos.m_123341_() - box.m_162395_(), pos.m_123342_() - box.m_162396_(), pos.m_123343_() - box.m_162398_());
                }
                for (Direction direction : Direction.values()) {
                    mutable.m_122159_((Vec3i)pos, direction);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (trunkPos.contains(mutable) || foliagePos.contains(mutable) || !state.m_61138_((Property)BlockStateProperties.f_61414_) || (Integer)state.m_61143_((Property)BlockStateProperties.f_61414_) <= tries + 1) continue;
                    BlockState foliage = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(tries + 1));
                    TreeFeatureAccessor.setBlockKnownShape((LevelWriter)level, (BlockPos)mutable, foliage);
                    if (box.m_71051_((Vec3i)mutable)) {
                        shape.m_142703_(mutable.m_123341_() - box.m_162395_(), mutable.m_123342_() - box.m_162396_(), mutable.m_123343_() - box.m_162398_());
                    }
                    foliagePos.add(mutable.m_7949_());
                }
            }
        }
        return shape;
    }

    private static /* synthetic */ boolean lambda$getTopPosition$3(UpwardBranchingTrunk trunk, BlockState state) {
        return state.m_204341_(trunk.canGrowThrough);
    }
}

