/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen;

import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VeinGrower {
    public static final GrowType[] GROW_TYPES = new GrowType[]{GrowType.SAME_POSITION, GrowType.SAME_PLANE, GrowType.WRAP_AROUND};
    private final GrowChecker growChecker;

    public VeinGrower(MultifaceBlock lichen) {
        this(new VeinGrowChecker(lichen));
    }

    public VeinGrower(GrowChecker growChecker) {
        this.growChecker = growChecker;
    }

    public boolean canGrow(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return DirectionUtils.stream().anyMatch(newDirection -> this.getGrowPos(state, getter, pos, direction, (Direction)newDirection, this.growChecker::canGrow).isPresent());
    }

    public Optional<GrowPos> grow(BlockState state, LevelAccessor level, BlockPos pos, Random random) {
        return DirectionUtils.shuffle(random).stream().filter(direction -> this.growChecker.canGrow(state, (Direction)direction)).map(direction -> this.grow(state, level, pos, (Direction)direction, random, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long grow(BlockState state, LevelAccessor level, BlockPos pos, boolean postProcess) {
        return DirectionUtils.stream().filter(direction -> this.growChecker.canGrow(state, (Direction)direction)).map(direction -> this.grow(state, level, pos, (Direction)direction, postProcess)).reduce(0L, Long::sum);
    }

    public Optional<GrowPos> grow(BlockState state, LevelAccessor level, BlockPos pos, Direction direction, Random random, boolean postProcess) {
        return DirectionUtils.shuffle(random).stream().map(newDirection -> this.grow(state, level, pos, direction, (Direction)newDirection, postProcess)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long grow(BlockState state, LevelAccessor level, BlockPos pos, Direction direction, boolean postProcess) {
        return DirectionUtils.stream().map(newDirection -> this.grow(state, level, pos, direction, (Direction)newDirection, postProcess)).filter(Optional::isPresent).count();
    }

    public Optional<GrowPos> grow(BlockState state, LevelAccessor world, BlockPos pos, Direction oldDirection, Direction newDirection, boolean postProcess) {
        return this.getGrowPos(state, (BlockGetter)world, pos, oldDirection, newDirection, this.growChecker::canGrow).flatMap(growPos -> this.place(world, (GrowPos)growPos, postProcess));
    }

    public Optional<GrowPos> getGrowPos(BlockState state, BlockGetter world, BlockPos pos, Direction oldDirection, Direction newDirection, GrowPosPredicate predicate) {
        if (newDirection.m_122434_() == oldDirection.m_122434_()) {
            return Optional.empty();
        }
        if (!(this.growChecker.canGrow(state) || this.growChecker.hasDirection(state, oldDirection) && !this.growChecker.hasDirection(state, newDirection))) {
            return Optional.empty();
        }
        for (GrowType growType : this.growChecker.getGrowTypes()) {
            GrowPos growPos = growType.getGrowPos(pos, newDirection, oldDirection);
            if (!predicate.test(world, pos, growPos)) continue;
            return Optional.of(growPos);
        }
        return Optional.empty();
    }

    public Optional<GrowPos> place(LevelAccessor world, GrowPos pos, boolean markForPostProcessing) {
        BlockState state = world.m_8055_(pos.pos());
        if (this.growChecker.place(world, pos, state, markForPostProcessing)) {
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static class VeinGrowChecker
    implements GrowChecker {
        protected MultifaceBlock multifaceBlock;

        public VeinGrowChecker(MultifaceBlock multifaceBlock) {
            this.multifaceBlock = multifaceBlock;
        }

        @Override
        @Nullable
        public BlockState getStateWithDirection(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
            return this.multifaceBlock.m_153940_(state, getter, pos, face);
        }

        protected boolean canGrow(BlockGetter getter, BlockPos pos, BlockPos growPos, Direction direction, BlockState state) {
            return state.m_60795_() || state.m_60713_((Block)this.multifaceBlock) || state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76170_();
        }

        @Override
        public boolean canGrow(BlockGetter getter, BlockPos pos, GrowPos growPos) {
            BlockState state = getter.m_8055_(growPos.pos());
            return this.canGrow(getter, pos, growPos.pos(), growPos.face(), state) && ((SculkVeinBlock)this.multifaceBlock).canGrowWithDirection(getter, state, growPos.pos(), growPos.face());
        }
    }

    public static interface GrowChecker {
        @Nullable
        public BlockState getStateWithDirection(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4);

        public boolean canGrow(BlockGetter var1, BlockPos var2, GrowPos var3);

        default public GrowType[] getGrowTypes() {
            return GROW_TYPES;
        }

        default public boolean hasDirection(BlockState state, Direction direction) {
            return SculkVeinBlock.hasFace(state, direction);
        }

        default public boolean canGrow(BlockState state) {
            return false;
        }

        default public boolean canGrow(BlockState state, Direction direction) {
            return this.canGrow(state) || this.hasDirection(state, direction);
        }

        default public boolean place(LevelAccessor world, GrowPos growPos, BlockState state, boolean postProcess) {
            BlockState blockState = this.getStateWithDirection(state, (BlockGetter)world, growPos.pos(), growPos.face());
            if (blockState != null) {
                if (postProcess) {
                    world.m_46865_(growPos.pos()).m_8113_(growPos.pos());
                }
                return world.m_7731_(growPos.pos(), blockState, 2);
            }
            return false;
        }
    }

    public static interface GrowPosPredicate {
        public boolean test(BlockGetter var1, BlockPos var2, GrowPos var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GrowType {
        SAME_POSITION{

            @Override
            public GrowPos getGrowPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new GrowPos(pos, newDirection);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public GrowPos getGrowPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new GrowPos(pos.m_142300_(newDirection), oldDirection);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public GrowPos getGrowPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new GrowPos(pos.m_142300_(newDirection).m_142300_(oldDirection), newDirection.m_122424_());
            }
        };


        public abstract GrowPos getGrowPos(BlockPos var1, Direction var2, Direction var3);
    }

    public record GrowPos(BlockPos pos, Direction face) {
    }
}

