/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.registry;

import com.cursedcauldron.wildbackport.core.api.CoreRegistry;
import com.cursedcauldron.wildbackport.core.mixin.access.OverworldBiomesAccessor;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class WBBiomes {
    public static final CoreRegistry<Biome> BIOMES = CoreRegistry.create(BuiltinRegistries.f_123865_, "wildbackport");
    public static final ResourceKey<Biome> MANGROVE_SWAMP = WBBiomes.create("mangrove_swamp", WBBiomes::mangroveSwamp);
    public static final ResourceKey<Biome> DEEP_DARK = WBBiomes.create("deep_dark", WBBiomes::deepDark);

    public static Biome mangroveSwamp() {
        MobSpawnSettings.Builder spawn = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawn);
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)generation);
        OverworldBiomesAccessor.callGlobalOverworldGeneration(generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        return new Biome.BiomeBuilder().m_47595_(Biome.BiomeCategory.SWAMP).m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(3832426).m_48037_(5077600).m_48019_(12638463).m_48040_(WBBiomes.calculateSkyColor(0.8f)).m_48043_(9285927).m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawn.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    public static Biome deepDark() {
        MobSpawnSettings.Builder spawn = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        generation.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        generation.m_204198_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        generation.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126849_);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_194722_((BiomeGenerationSettings.Builder)generation, (boolean)true);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        return new Biome.BiomeBuilder().m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47597_(Biome.Precipitation.RAIN).m_47609_(0.8f).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(WBBiomes.calculateSkyColor(0.8f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawn.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static ResourceKey<Biome> create(String key, Supplier<Biome> biome) {
        BIOMES.register(key, biome);
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("wildbackport", key));
    }

    protected static int calculateSkyColor(float temperature) {
        float modifier = temperature / 3.0f;
        modifier = Mth.m_14036_((float)modifier, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - modifier * 0.05f), (float)(0.5f + modifier * 0.1f), (float)1.0f);
    }
}

