/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public class TadpoleBucketItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Supplier<? extends SoundEvent> emptySound;

    public TadpoleBucketItem(Supplier<? extends EntityType<?>> entityType, Fluid fluid, Supplier<? extends SoundEvent> emptySound, Item.Properties properties) {
        super(fluid, properties);
        this.entityType = entityType;
        this.emptySound = emptySound;
    }

    public void m_142131_(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.spawn(server, stack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor access, BlockPos pos) {
        access.m_5594_(player, pos, this.emptySound.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(ServerLevel level, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityType.get().m_20592_(level, stack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_142278_(stack.m_41784_());
            bucketable.m_142139_(true);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltip) {
        CompoundTag tag;
        if (this.entityType.get() == EntityType.f_20489_ && (tag = stack.m_41783_()) != null && tag.m_128425_("BucketVariantTag", 3)) {
            int variant = tag.m_128451_("BucketVariantTag");
            ChatFormatting[] format = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            String base = "color.minecraft." + TropicalFish.m_30050_((int)variant);
            String pattern = "color.minecraft." + TropicalFish.m_30052_((int)variant);
            for (int i = 0; i < TropicalFish.f_30007_.length; ++i) {
                if (variant != TropicalFish.f_30007_[i]) continue;
                components.add((Component)new TranslatableComponent(TropicalFish.m_30030_((int)i)).m_130944_(format));
                return;
            }
            components.add((Component)new TranslatableComponent(TropicalFish.m_30054_((int)variant)).m_130944_(format));
            TranslatableComponent component = new TranslatableComponent(base);
            if (!base.equals(pattern)) {
                component.m_130946_(", ").m_7220_((Component)new TranslatableComponent(pattern));
            }
            component.m_130944_(format);
            components.add((Component)component);
        }
    }
}

