/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.items;

import com.cursedcauldron.wildbackport.common.items.Instrument;
import com.cursedcauldron.wildbackport.common.registry.WBGameEvents;
import com.cursedcauldron.wildbackport.common.registry.WBRegistries;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GoatHornItem
extends Item {
    private static final String INSTRUMENT_KEY = "instrument";
    private TagKey<Instrument> instruments;

    public GoatHornItem(Item.Properties properties, TagKey<Instrument> instrumentTag) {
        super(properties);
        this.instruments = instrumentTag;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, components, tooltipFlag);
        Optional instrument = this.getInstrument(stack).flatMap(Holder::m_203543_);
        if (instrument.isPresent()) {
            TranslatableComponent component = new TranslatableComponent(Util.m_137492_((String)INSTRUMENT_KEY, (ResourceLocation)((ResourceKey)instrument.get()).m_135782_()));
            components.add((Component)component.m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ItemStack getStackForInstrument(Item item, Holder<Instrument> instrument) {
        ItemStack stack = new ItemStack((ItemLike)item);
        GoatHornItem.setInstrument(stack, instrument);
        return stack;
    }

    public static void setRandomInstrumentFromTag(ItemStack stack, TagKey<Instrument> tag, Random random) {
        Optional instrument = WBRegistries.INSTRUMENT.registry().m_203431_(tag).flatMap(holders -> holders.m_203450_(random));
        instrument.ifPresent(holder -> GoatHornItem.setInstrument(stack, (Holder<Instrument>)holder));
    }

    private static void setInstrument(ItemStack stack, Holder<Instrument> instrument) {
        stack.m_41784_().m_128359_(INSTRUMENT_KEY, ((ResourceKey)instrument.m_203543_().orElseThrow(() -> new IllegalStateException("Invalid instrument"))).m_135782_().toString());
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab)) {
            for (Holder holder : WBRegistries.INSTRUMENT.registry().m_206058_(this.instruments)) {
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Optional<Holder<Instrument>> holder = this.getInstrument(stack);
        if (holder.isPresent()) {
            Instrument instrument = (Instrument)holder.get().m_203334_();
            player.m_6672_(hand);
            GoatHornItem.playSound(level, player, instrument);
            player.m_36335_().m_41524_((Item)this, instrument.useDuration());
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        Optional<Holder<Instrument>> instrument = this.getInstrument(stack);
        return instrument.map(holder -> ((Instrument)holder.m_203334_()).useDuration()).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack stack) {
        ResourceLocation location;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (location = ResourceLocation.m_135820_((String)tag.m_128461_(INSTRUMENT_KEY))) != null) {
            return WBRegistries.INSTRUMENT.registry().m_203636_(ResourceKey.m_135785_(WBRegistries.INSTRUMENT.key(), (ResourceLocation)location));
        }
        Iterator instruments = WBRegistries.INSTRUMENT.registry().m_206058_(this.instruments).iterator();
        return instruments.hasNext() ? Optional.of((Holder)instruments.next()) : Optional.empty();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    private static void playSound(Level level, Player player, Instrument instrument) {
        level.m_6269_(player, (Entity)player, instrument.soundEvent(), SoundSource.RECORDS, instrument.range() / 16.0f, 1.0f);
        level.m_151552_(WBGameEvents.INSTRUMENT_PLAY.get(), (Entity)player);
    }
}

