/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.items;

import com.cursedcauldron.wildbackport.common.entities.ChestBoat;
import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChestBoatItem
extends Item {
    private static final Predicate<Entity> RIDERS = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final Boat.Type type;
    private final boolean chested;

    public ChestBoatItem(boolean chested, Boat.Type type, Item.Properties properties) {
        super(properties);
        this.chested = chested;
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = ChestBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Vec3 viewVector = player.m_20252_(1.0f);
        List entities = level.m_6249_((Entity)player, player.m_142469_().m_82369_(viewVector.m_82490_(5.0)).m_82400_(1.0), RIDERS);
        if (!entities.isEmpty()) {
            Vec3 eyePosition = player.m_146892_();
            for (Entity entity : entities) {
                AABB box = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!box.m_82390_(eyePosition)) continue;
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            MangroveBoat boat = this.create(level, hitResult.m_82450_());
            boat.m_38332_(this.type);
            boat.m_146922_(player.m_146908_());
            if (!level.m_45756_((Entity)boat, boat.m_142469_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
                level.m_142346_((Entity)player, GameEvent.f_157810_, new BlockPos(hitResult.m_82450_()));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public MangroveBoat create(Level level, Vec3 pos) {
        if (this.chested) {
            return new ChestBoat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
        return new MangroveBoat(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }
}

