/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.entities.warden.Angriness;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.SerializableUUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WardenAngerManager {
    private int updateTimer = Mth.m_144928_((Random)new Random(), (int)0, (int)2);
    int primeAnger;
    private static final Codec<Pair<UUID, Integer>> SUSPECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableUUID.f_123272_.fieldOf("uuid").forGetter(Pair::getFirst), (App)ExtraCodecs.f_144628_.fieldOf("anger").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private final Predicate<Entity> suspectPredicate;
    protected final ArrayList<Entity> suspects;
    private final SuspectComparator suspectComparator;
    protected final Object2IntMap<Entity> suspectsToAngerLevel;
    protected final Object2IntMap<UUID> suspectUuidsToAngerLevel;

    public static Codec<WardenAngerManager> codec(Predicate<Entity> validTarget) {
        return RecordCodecBuilder.create(instance -> instance.group((App)SUSPECT_CODEC.listOf().fieldOf("suspects").orElse(Collections.emptyList()).forGetter(WardenAngerManager::getSuspects)).apply((Applicative)instance, suspects -> new WardenAngerManager(validTarget, (List<Pair<UUID, Integer>>)suspects)));
    }

    public WardenAngerManager(Predicate<Entity> suspectPredicate, List<Pair<UUID, Integer>> suspectUuidsToAngerLevel) {
        this.suspectPredicate = suspectPredicate;
        this.suspects = new ArrayList();
        this.suspectComparator = new SuspectComparator(this);
        this.suspectsToAngerLevel = new Object2IntOpenHashMap();
        this.suspectUuidsToAngerLevel = new Object2IntOpenHashMap(suspectUuidsToAngerLevel.size());
        suspectUuidsToAngerLevel.forEach(suspect -> this.suspectUuidsToAngerLevel.put((Object)((UUID)suspect.getFirst()), (Integer)suspect.getSecond()));
    }

    private List<Pair<UUID, Integer>> getSuspects() {
        return Streams.concat((Stream[])new Stream[]{this.suspects.stream().map(suspect -> Pair.of((Object)suspect.m_142081_(), (Object)this.suspectsToAngerLevel.getInt(suspect))), this.suspectUuidsToAngerLevel.object2IntEntrySet().stream().map(entry -> Pair.of((Object)((UUID)entry.getKey()), (Object)entry.getIntValue()))}).collect(Collectors.toList());
    }

    public void tick(ServerLevel level, Predicate<Entity> suspectPredicate) {
        --this.updateTimer;
        if (this.updateTimer <= 0) {
            this.updateSuspectsMap(level);
            this.updateTimer = 2;
        }
        ObjectIterator uuidToAnger = this.suspectUuidsToAngerLevel.object2IntEntrySet().iterator();
        while (uuidToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)uuidToAnger.next();
            int anger = entry.getIntValue();
            if (anger <= 1) {
                uuidToAnger.remove();
                continue;
            }
            entry.setValue(anger - 1);
        }
        ObjectIterator suspectToAnger = this.suspectsToAngerLevel.object2IntEntrySet().iterator();
        while (suspectToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)suspectToAnger.next();
            int anger = entry.getIntValue();
            Entity entity = (Entity)entry.getKey();
            Entity.RemovalReason reason = entity.m_146911_();
            if (anger > 1 && suspectPredicate.test(entity) && reason == null) {
                entry.setValue(anger - 1);
                continue;
            }
            this.suspects.remove(entity);
            suspectToAnger.remove();
            if (anger <= 1 || reason == null) continue;
            switch (reason) {
                case CHANGED_DIMENSION: 
                case UNLOADED_TO_CHUNK: 
                case UNLOADED_WITH_PLAYER: {
                    this.suspectUuidsToAngerLevel.put((Object)entity.m_142081_(), anger - 1);
                }
            }
        }
        this.updatePrimeAnger();
    }

    private void updatePrimeAnger() {
        this.primeAnger = 0;
        this.suspects.sort(this.suspectComparator);
        if (this.suspects.size() == 1) {
            this.primeAnger = this.suspectsToAngerLevel.getInt((Object)this.suspects.get(0));
        }
    }

    private void updateSuspectsMap(ServerLevel level) {
        ObjectIterator uuidsToAnger = this.suspectUuidsToAngerLevel.object2IntEntrySet().iterator();
        while (uuidsToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)uuidsToAnger.next();
            int anger = entry.getIntValue();
            Entity entity = level.m_8791_((UUID)entry.getKey());
            if (entity == null) continue;
            this.suspectsToAngerLevel.put((Object)entity, anger);
            this.suspects.add(entity);
            uuidsToAnger.remove();
        }
    }

    public int increaseAngerAt(Entity entity, int amount) {
        boolean isTarget = !this.suspectsToAngerLevel.containsKey((Object)entity);
        int angerLevel = this.suspectsToAngerLevel.computeInt((Object)entity, (suspect, anger) -> Math.min(150, (anger == null ? 0 : anger) + amount));
        if (isTarget) {
            int modifier = this.suspectUuidsToAngerLevel.removeInt((Object)entity.m_142081_());
            this.suspectsToAngerLevel.put((Object)entity, angerLevel += modifier);
            this.suspects.add(entity);
        }
        this.updatePrimeAnger();
        return angerLevel;
    }

    public void removeSuspect(Entity entity) {
        this.suspectsToAngerLevel.removeInt((Object)entity);
        this.suspects.remove(entity);
        this.updatePrimeAnger();
    }

    @Nullable
    private Entity getPrimeSuspectInternal() {
        return this.suspects.stream().filter(this.suspectPredicate).findFirst().orElse(null);
    }

    public int getAngerFor(@Nullable Entity entity) {
        return entity == null ? this.primeAnger : this.suspectsToAngerLevel.getInt((Object)entity);
    }

    public Optional<LivingEntity> getPrimeSuspect() {
        return Optional.ofNullable(this.getPrimeSuspectInternal()).filter(suspect -> suspect instanceof LivingEntity).map(suspect -> (LivingEntity)suspect);
    }

    protected record SuspectComparator(WardenAngerManager angerManagement) implements Comparator<Entity>
    {
        @Override
        public int compare(Entity firstSuspect, Entity secondSuspect) {
            boolean isAngryWithSecondSuspect;
            if (firstSuspect.equals((Object)secondSuspect)) {
                return 0;
            }
            int angerToFirstSuspect = this.angerManagement.suspectsToAngerLevel.getOrDefault((Object)firstSuspect, 0);
            int angerToSecondSuspect = this.angerManagement.suspectsToAngerLevel.getOrDefault((Object)secondSuspect, 0);
            this.angerManagement.primeAnger = Math.max(this.angerManagement.primeAnger, Math.max(angerToFirstSuspect, angerToSecondSuspect));
            boolean isAngryWithFirstSuspect = Angriness.getForAnger(angerToFirstSuspect).isAngry();
            if (isAngryWithFirstSuspect != (isAngryWithSecondSuspect = Angriness.getForAnger(angerToSecondSuspect).isAngry())) {
                return isAngryWithFirstSuspect ? -1 : 1;
            }
            boolean isFirstSuspectPlayer = firstSuspect instanceof Player;
            boolean isSecondSuspectPlayer = secondSuspect instanceof Player;
            if (isFirstSuspectPlayer != isSecondSuspectPlayer) {
                return isFirstSuspectPlayer ? -1 : 1;
            }
            return Integer.compare(angerToSecondSuspect, angerToFirstSuspect);
        }
    }
}

