/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.client.registry.WBCriteriaTriggers;
import com.cursedcauldron.wildbackport.common.utils.PositionUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SerializableUUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VibrationHandler
implements GameEventListener {
    protected final PositionSource source;
    protected final int range;
    protected final VibrationConfig config;
    @Nullable
    protected Vibration event;
    protected float distance;
    protected int delay;

    public static Codec<VibrationHandler> codec(VibrationConfig config) {
        return RecordCodecBuilder.create(instance -> instance.group((App)PositionSource.f_157868_.fieldOf("source").forGetter(listener -> listener.source), (App)ExtraCodecs.f_144628_.fieldOf("range").forGetter(listener -> listener.range), (App)Vibration.CODEC.optionalFieldOf("event").forGetter(listener -> Optional.ofNullable(listener.event)), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("event_distance").orElse((Object)Float.valueOf(0.0f)).forGetter(listener -> Float.valueOf(listener.distance)), (App)ExtraCodecs.f_144628_.fieldOf("event_delay").orElse((Object)0).forGetter(listener -> listener.delay)).apply((Applicative)instance, (source, range, event, distance, delay) -> new VibrationHandler((PositionSource)source, (int)range, config, event.orElse(null), distance.floatValue(), (int)delay)));
    }

    public VibrationHandler(PositionSource source, int range, VibrationConfig config, @Nullable Vibration event, float distance, int delay) {
        this.source = source;
        this.range = range;
        this.config = config;
        this.event = event;
        this.distance = distance;
        this.delay = delay;
    }

    public VibrationHandler(PositionSource source, int range, VibrationConfig config) {
        this(source, range, config, null, 0.0f, 0);
    }

    public void tick(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.event != null) {
                --this.delay;
                if (this.delay <= 0) {
                    this.delay = 0;
                    this.config.onSignalReceive(server, this, new BlockPos(this.event.pos), this.event.event, this.event.getEntity(server).orElse(null), this.event.getProjectileOwner(server).orElse(null), this.distance);
                    this.event = null;
                }
            }
        }
    }

    public PositionSource m_142460_() {
        return this.source;
    }

    public int m_142078_() {
        return this.range;
    }

    public boolean m_142721_(Level level, GameEvent event, @Nullable Entity entity, BlockPos pos) {
        if (this.event != null) {
            return false;
        }
        Optional optional = this.source.m_142502_(level);
        if (!this.config.isValidVibration(event, entity)) {
            return false;
        }
        Vec3 source = PositionUtils.toVec(pos);
        Vec3 target = PositionUtils.toVec((BlockPos)optional.get());
        if (!this.config.shouldListen((ServerLevel)level, this, new BlockPos(source), event, entity)) {
            return false;
        }
        if (VibrationHandler.isOccluded(level, source, target)) {
            return false;
        }
        this.scheduleSignal(level, event, entity, source, target);
        return true;
    }

    private void scheduleSignal(Level level, GameEvent event, @Nullable Entity entity, Vec3 source, Vec3 target) {
        this.distance = (float)source.m_82554_(target);
        this.event = new Vibration(event, this.distance, source, entity);
        this.delay = Mth.m_14143_((float)this.distance);
        ((ServerLevel)level).m_143283_(new VibrationPath(PositionUtils.toBlockPos(source), this.source, this.delay));
        this.config.onSignalSchedule();
    }

    private static boolean isOccluded(Level level, Vec3 source, Vec3 target) {
        Vec3 sourceVec = new Vec3((double)Mth.m_14107_((double)source.f_82479_) + 0.5, (double)Mth.m_14107_((double)source.f_82480_) + 0.5, (double)Mth.m_14107_((double)source.f_82481_) + 0.5);
        Vec3 targetVec = new Vec3((double)Mth.m_14107_((double)target.f_82479_) + 0.5, (double)Mth.m_14107_((double)target.f_82480_) + 0.5, (double)Mth.m_14107_((double)target.f_82481_) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 offsetVec = PositionUtils.relative(sourceVec, direction, 1.0E-5f);
            if (level.m_151353_(new ClipBlockStateContext(offsetVec, targetVec, state -> state.m_204336_(BlockTags.f_144272_))).m_6662_() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }

    public static interface VibrationConfig {
        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.f_144302_;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean isValidVibration(GameEvent event, @Nullable Entity entity) {
            if (!event.m_204528_(this.getListenableEvents())) {
                return false;
            }
            if (entity != null) {
                if (entity.m_5833_()) {
                    return false;
                }
                if (entity.m_20161_() && event.m_204528_(GameEventTags.f_144303_)) {
                    if (this.canTriggerAvoidVibration() && entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        WBCriteriaTriggers.AVOID_VIBRATION.m_53645_(player);
                    }
                    return false;
                }
                return !entity.m_142050_();
            }
            return true;
        }

        public boolean shouldListen(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, @Nullable Entity var5);

        public void onSignalReceive(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, @Nullable Entity var5, @Nullable Entity var6, float var7);

        default public void onSignalSchedule() {
        }
    }

    public record Vibration(GameEvent event, float distance, Vec3 pos, @Nullable UUID source, @Nullable UUID projectileOwner, @Nullable Entity entity) {
        public static final Codec<Vibration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_175412_.m_194605_().fieldOf("game_event").forGetter(Vibration::event), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(Vibration::distance), (App)PositionUtils.VEC_CODEC.fieldOf("pos").forGetter(Vibration::pos), (App)SerializableUUID.f_123272_.optionalFieldOf("source").forGetter(entity -> Optional.ofNullable(entity.source())), (App)SerializableUUID.f_123272_.optionalFieldOf("projectile_owner").forGetter(entity -> Optional.ofNullable(entity.projectileOwner()))).apply((Applicative)instance, (event, distance, pos, source, projectileOwner) -> new Vibration((GameEvent)event, distance.floatValue(), (Vec3)pos, source.orElse(null), projectileOwner.orElse(null))));

        public Vibration(GameEvent event, float distance, Vec3 pos, @Nullable UUID source, @Nullable UUID projectileOwner) {
            this(event, distance, pos, source, projectileOwner, null);
        }

        public Vibration(GameEvent event, float distance, Vec3 pos, @Nullable Entity entity) {
            this(event, distance, pos, entity == null ? null : entity.m_142081_(), Vibration.getProjectileOwner(entity), entity);
        }

        @Nullable
        private static UUID getProjectileOwner(@Nullable Entity entity) {
            Projectile projectile;
            if (entity instanceof Projectile && (projectile = (Projectile)entity).m_37282_() != null) {
                return projectile.m_37282_().m_142081_();
            }
            return null;
        }

        public Optional<Entity> getEntity(ServerLevel level) {
            return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.source).map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)));
        }

        public Optional<Entity> getProjectileOwner(ServerLevel level) {
            return this.getEntity(level).filter(entity -> entity instanceof Projectile).map(entity -> (Projectile)entity).map(Projectile::m_37282_).or(() -> Optional.ofNullable(this.projectileOwner).map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)));
        }
    }
}

