/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.allay;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Allay;
import com.cursedcauldron.wildbackport.common.entities.brain.AllayBrain;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.utils.MobUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GiveInventoryToLookTarget<E extends LivingEntity>
extends Behavior<E> {
    private final Function<LivingEntity, Optional<PositionTracker>> lookTarget;
    private final float speed;

    public GiveInventoryToLookTarget(Function<LivingEntity, Optional<PositionTracker>> lookTarget, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, WBMemoryModules.ITEM_PICKUP_COOLDOWN_TICKS.get(), (Object)MemoryStatus.REGISTERED));
        this.lookTarget = lookTarget;
        this.speed = speed;
    }

    protected boolean m_6114_(ServerLevel level, E entity) {
        return this.hasItemAndTarget(entity);
    }

    protected boolean m_6737_(ServerLevel level, E entity, long time) {
        return this.hasItemAndTarget(entity);
    }

    protected void m_6735_(ServerLevel level, E entity, long time) {
        this.lookTarget.apply((LivingEntity)entity).ifPresent(target -> MobUtils.walkTowards(entity, target, this.speed, 3));
    }

    protected void m_6725_(ServerLevel level, E entity, long time) {
        ItemStack stack;
        PositionTracker target;
        double distance;
        Optional<PositionTracker> lookTarget = this.lookTarget.apply((LivingEntity)entity);
        if (lookTarget.isPresent() && (distance = (target = lookTarget.get()).m_7024_().m_82554_(entity.m_146892_())) < 3.0 && !(stack = ((InventoryCarrier)entity).m_141944_().m_7407_(0, 1)).m_41619_()) {
            GiveInventoryToLookTarget.playThrowSound(entity, stack, GiveInventoryToLookTarget.offsetTarget(target));
            if (entity instanceof Allay) {
                Allay allay = (Allay)((Object)entity);
                AllayBrain.getLikedPlayer((LivingEntity)allay).ifPresent(player -> this.triggerCriteria(target, stack, (ServerPlayer)player));
            }
            entity.m_6274_().m_21879_(WBMemoryModules.ITEM_PICKUP_COOLDOWN_TICKS.get(), (Object)60);
        }
    }

    private void triggerCriteria(PositionTracker target, ItemStack stack, ServerPlayer player) {
        BlockPos pos = target.m_6675_().m_7495_();
    }

    private boolean hasItemAndTarget(E entity) {
        return !((InventoryCarrier)entity).m_141944_().m_7983_() && this.lookTarget.apply((LivingEntity)entity).isPresent();
    }

    private static Vec3 offsetTarget(PositionTracker tracker) {
        return tracker.m_7024_().m_82520_(0.0, 1.0, 0.0);
    }

    public static void playThrowSound(LivingEntity entity, ItemStack stack, Vec3 pos) {
        Vec3 velocity = new Vec3((double)0.2f, (double)0.3f, (double)0.2f);
        MobUtils.give(entity, stack, pos, velocity, 0.2f);
        Level level = entity.f_19853_;
        if (level.m_46467_() % 7L == 0L && level.f_46441_.nextDouble() < 0.9) {
            float pitch = ((Float)Util.m_143804_(Allay.THROW_SOUND_PITCHES, (Random)level.m_5822_())).floatValue();
            level.m_6269_(null, (Entity)entity, WBSoundEvents.ALLAY_ITEM_THROW, SoundSource.NEUTRAL, 1.0f, pitch);
        }
    }
}

