/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain;

import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Digging;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Dismount;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Emerging;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.FindRoarTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.ForgetAttackTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.GoToTargetLocation;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Roar;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SetWardenLookTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Sniffing;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SonicBoom;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.TryToSniff;
import com.cursedcauldron.wildbackport.common.registry.entity.WBActivities;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBSensorTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class WardenBrain {
    private static final int DIGGING_DURATION = Mth.m_14167_((float)100.0f);
    public static final int EMERGE_DURATION = Mth.m_14167_((float)133.59999f);
    public static final int ROAR_DURATION = Mth.m_14167_((float)84.0f);
    private static final int SNIFFING_DURATION = Mth.m_14167_((float)83.2f);
    private static final List<SensorType<? extends Sensor<? super Warden>>> SENSOR_TYPES = List.of(SensorType.f_26812_, WBSensorTypes.WARDEN_ENTITY_SENSOR.get());
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_26368_, MemoryModuleType.f_148206_, MemoryModuleType.f_26333_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, MemoryModuleType.f_26377_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_148194_, WBMemoryModules.ROAR_TARGET.get(), WBMemoryModules.DISTURBANCE_LOCATION.get(), WBMemoryModules.RECENT_PROJECTILE.get(), WBMemoryModules.IS_SNIFFING.get(), WBMemoryModules.IS_EMERGING.get(), WBMemoryModules.ROAR_SOUND_DELAY.get(), WBMemoryModules.DIG_COOLDOWN.get(), WBMemoryModules.ROAR_SOUND_COOLDOWN.get(), WBMemoryModules.SNIFF_COOLDOWN.get(), WBMemoryModules.TOUCH_COOLDOWN.get(), WBMemoryModules.VIBRATION_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_SOUND_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_SOUND_DELAY.get());
    private static final Behavior<Warden> DIG_COOLDOWN_SETTER = new Behavior<Warden>((Map)ImmutableMap.of(WBMemoryModules.DIG_COOLDOWN.get(), (Object)MemoryStatus.REGISTERED)){

        protected void start(ServerLevel level, Warden warden, long time) {
            WardenBrain.resetDigCooldown((LivingEntity)warden);
        }
    };

    public static void updateActivities(Warden warden) {
        warden.m_6274_().m_21926_((List)ImmutableList.of((Object)WBActivities.EMERGE.get(), (Object)WBActivities.DIG.get(), (Object)WBActivities.ROAR.get(), (Object)Activity.f_37988_, (Object)WBActivities.INVESTIGATE.get(), (Object)WBActivities.SNIFF.get(), (Object)Activity.f_37979_));
    }

    public static Brain<?> makeBrain(Warden warden, Dynamic<?> dynamic) {
        Brain.Provider provider = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain = provider.m_22073_(dynamic);
        WardenBrain.initCoreActivity((Brain<Warden>)brain);
        WardenBrain.initEmergeActivity((Brain<Warden>)brain);
        WardenBrain.initDiggingActivity((Brain<Warden>)brain);
        WardenBrain.initIdleActivity((Brain<Warden>)brain);
        WardenBrain.initRoarActivity((Brain<Warden>)brain);
        WardenBrain.initFightActivity(warden, (Brain<Warden>)brain);
        WardenBrain.initInvestigateActivity((Brain<Warden>)brain);
        WardenBrain.initSniffingActivity((Brain<Warden>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Warden> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)((Object)new SetWardenLookTarget()), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initEmergeActivity(Brain<Warden> brain) {
        brain.m_21895_(WBActivities.EMERGE.get(), 5, ImmutableList.of(new Emerging(EMERGE_DURATION)), WBMemoryModules.IS_EMERGING.get());
    }

    private static void initDiggingActivity(Brain<Warden> brain) {
        brain.m_21903_(WBActivities.DIG.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Dismount())), (Object)Pair.of((Object)1, new Digging(DIGGING_DURATION))), (Set)ImmutableSet.of((Object)Pair.of(WBMemoryModules.ROAR_TARGET.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(WBMemoryModules.DIG_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initIdleActivity(Brain<Warden> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), (Object)((Object)new TryToSniff()), (Object)new RunOne((Map)ImmutableMap.of(WBMemoryModules.IS_SNIFFING.get(), (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.5f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(Brain<Warden> brain) {
        brain.m_21895_(WBActivities.INVESTIGATE.get(), 5, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), new GoToTargetLocation(WBMemoryModules.DISTURBANCE_LOCATION.get(), 2, 0.7f)), WBMemoryModules.DISTURBANCE_LOCATION.get());
    }

    private static void initSniffingActivity(Brain<Warden> brain) {
        brain.m_21895_(WBActivities.SNIFF.get(), 5, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), new Sniffing(SNIFFING_DURATION)), WBMemoryModules.IS_SNIFFING.get());
    }

    private static void initRoarActivity(Brain<Warden> brain) {
        brain.m_21895_(WBActivities.ROAR.get(), 10, ImmutableList.of((Object)((Object)new Roar())), WBMemoryModules.ROAR_TARGET.get());
    }

    private static void initFightActivity(Warden warden, Brain<Warden> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of(DIG_COOLDOWN_SETTER, new ForgetAttackTarget<Warden>(entity -> !warden.getAngriness().isAngry() || !warden.isValidTarget((Entity)entity), WardenBrain::removeDeadSuspect, false), (Object)new SetEntityLookTarget(entity -> WardenBrain.isTargeting(warden, entity), (float)warden.m_21133_(Attributes.f_22277_)), (Object)new SetWalkTargetFromAttackTargetIfTargetOutOfReach(1.2f), (Object)((Object)new SonicBoom()), (Object)new MeleeAttack(18)), MemoryModuleType.f_26372_);
    }

    private static boolean isTargeting(Warden warden, LivingEntity entity) {
        return warden.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(target -> target == entity).isPresent();
    }

    private static void removeDeadSuspect(Warden warden, LivingEntity suspect) {
        if (!warden.isValidTarget((Entity)suspect)) {
            warden.removeSuspect((Entity)suspect);
        }
        WardenBrain.resetDigCooldown((LivingEntity)warden);
    }

    public static void resetDigCooldown(LivingEntity warden) {
        if (warden.m_6274_().m_21874_(WBMemoryModules.DIG_COOLDOWN.get())) {
            warden.m_6274_().m_21882_(WBMemoryModules.DIG_COOLDOWN.get(), (Object)Unit.INSTANCE, 1200L);
        }
    }

    public static void lookAtDisturbance(Warden warden, BlockPos pos) {
        if (warden.f_19853_.m_6857_().m_61937_(pos) && warden.getPrimeSuspect().isEmpty() && warden.m_6274_().m_21952_(MemoryModuleType.f_26372_).isEmpty()) {
            WardenBrain.resetDigCooldown((LivingEntity)warden);
            warden.m_6274_().m_21882_(WBMemoryModules.SNIFF_COOLDOWN.get(), (Object)Unit.INSTANCE, 100L);
            warden.m_6274_().m_21882_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos), 100L);
            warden.m_6274_().m_21882_(WBMemoryModules.DISTURBANCE_LOCATION.get(), (Object)pos, 100L);
            warden.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        }
    }
}

