/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.common.entities.MangroveBoat;
import com.cursedcauldron.wildbackport.common.registry.WBItems;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class ChestBoat
extends MangroveBoat
implements Container,
MenuProvider {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public ChestBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
    }

    public ChestBoat(Level level, double x, double y, double z) {
        super(WBEntityTypes.CHEST_BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public double m_6048_() {
        return 0.15f;
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < 1;
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.lootTable != null) {
            tag.m_128359_("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                tag.m_128356_("LootTableSeed", this.lootTableSeed);
            }
        } else {
            ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (tag.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(tag.m_128461_("LootTable"));
            this.lootTableSeed = tag.m_128454_("LootTableSeed");
        } else {
            ContainerHelper.m_18980_((CompoundTag)tag, this.stacks);
        }
    }

    @Override
    protected void dropItems(DamageSource source) {
        super.dropItems(source);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            Entity entity;
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
            if (!this.f_19853_.f_46443_ && (entity = source.m_7640_()) != null && entity.m_6095_() == EntityType.f_20532_) {
                PiglinAi.m_34873_((Player)((Player)entity), (boolean)true);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.f_19853_.f_46443_ && reason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            player.m_5893_((MenuProvider)this);
            if (!player.f_19853_.f_46443_) {
                this.m_146852_(GameEvent.f_157803_, (Entity)player);
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void openInventory(Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.f_19853_.m_5776_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    @Override
    public Item m_38369_() {
        return switch (this.m_38387_()) {
            case Boat.Type.OAK -> WBItems.OAK_CHEST_BOAT.get();
            case Boat.Type.SPRUCE -> WBItems.SPRUCE_CHEST_BOAT.get();
            case Boat.Type.BIRCH -> WBItems.BIRCH_CHEST_BOAT.get();
            case Boat.Type.JUNGLE -> WBItems.JUNGLE_CHEST_BOAT.get();
            case Boat.Type.ACACIA -> WBItems.ACACIA_CHEST_BOAT.get();
            case Boat.Type.DARK_OAK -> WBItems.DARK_OAK_CHEST_BOAT.get();
            default -> WBItems.MANGROVE_CHEST_BOAT.get();
        };
    }

    public void unpackLootTable(@Nullable Player player) {
        MinecraftServer server = this.f_19853_.m_142572_();
        if (this.lootTable != null && server != null) {
            LootTable lootTable = server.m_129898_().m_79217_(this.lootTable);
            if (player != null) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, this.lootTable);
            }
            this.lootTable = null;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78965_(this.lootTableSeed);
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            lootTable.m_79123_((Container)this, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public void m_6211_() {
        this.unpackLootTable(null);
        this.stacks.clear();
    }

    public int m_6643_() {
        return 27;
    }

    public ItemStack m_8020_(int slot) {
        this.unpackLootTable(null);
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.unpackLootTable(null);
        return ContainerHelper.m_18969_(this.stacks, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        this.unpackLootTable(null);
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.stacks.set(slot, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.unpackLootTable(null);
        this.stacks.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int slot) {
        return slot >= 0 && slot < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return ChestBoat.this.m_8020_(slot);
            }

            public boolean m_142104_(ItemStack stack) {
                ChestBoat.this.m_6836_(slot, stack);
                return true;
            }
        } : super.m_141942_(slot);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return !this.m_146910_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.lootTable == null || !player.m_5833_()) {
            this.unpackLootTable(inventory.f_35978_);
            return ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this);
        }
        return null;
    }
}

