/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks.entity;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.particle.ShriekParticleOptions;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.warden.VibrationHandler;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenSpawnHelper;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenSpawnTracker;
import com.cursedcauldron.wildbackport.common.registry.WBBlockEntities;
import com.cursedcauldron.wildbackport.common.registry.WBGameEvents;
import com.cursedcauldron.wildbackport.common.registry.WBGameRules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.tag.WBGameEventTags;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends BlockEntity
implements VibrationHandler.VibrationConfig {
    private static final Int2ObjectMap<SoundEvent> SOUND_BY_LEVEL = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(1, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSE);
        map.put(2, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSER);
        map.put(3, (Object)WBSoundEvents.WARDEN_NEARBY_CLOSEST);
        map.put(4, (Object)WBSoundEvents.WARDEN_LISTENING_ANGRY);
    });
    private int warningLevel;
    private VibrationHandler listener;

    public SculkShriekerBlockEntity(BlockPos pos, BlockState state) {
        super(WBBlockEntities.SCULK_SHRIEKER.get(), pos, state);
        this.listener = new VibrationHandler((PositionSource)new BlockPositionSource(this.f_58858_), 8, this, null, 0.0f, 0);
    }

    public VibrationHandler getListener() {
        return this.listener;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("warning_level", 99)) {
            this.warningLevel = tag.m_128451_("warning_level");
        }
        if (tag.m_128425_("listener", 10)) {
            VibrationHandler.codec(this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(listener -> {
                this.listener = listener;
            });
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("warning_level", this.warningLevel);
        VibrationHandler.codec(this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(listener -> tag.m_128365_("listener", listener));
    }

    @Override
    public TagKey<GameEvent> getListenableEvents() {
        return WBGameEventTags.SHRIEKER_CAN_LISTEN;
    }

    @Override
    public boolean shouldListen(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable Entity entity) {
        return !this.m_58901_() && (Boolean)this.m_58900_().m_61143_((Property)SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(entity) != null;
    }

    @Nullable
    public static ServerPlayer tryGetPlayer(@Nullable Entity entity) {
        Projectile projectile;
        Entity owner;
        Entity passenger;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        if (entity != null && (passenger = entity.m_6688_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)passenger;
            return player;
        }
        if (entity instanceof Projectile && (owner = (projectile = (Projectile)entity).m_37282_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            return player;
        }
        return null;
    }

    @Override
    public void onSignalReceive(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable Entity entity, @Nullable Entity source, float distance) {
        this.tryShriek(level, SculkShriekerBlockEntity.tryGetPlayer(source != null ? source : entity));
    }

    public void tryShriek(ServerLevel level, @Nullable ServerPlayer player) {
        BlockState state;
        if (player != null && !((Boolean)(state = this.m_58900_()).m_61143_((Property)SculkShriekerBlock.SHRIEKING)).booleanValue()) {
            this.warningLevel = 0;
            if (!this.canRespond(level) || this.tryToWarn(level, player)) {
                this.shriek(level, (Entity)player);
            }
        }
    }

    private boolean tryToWarn(ServerLevel level, ServerPlayer player) {
        OptionalInt warning = WardenSpawnTracker.tryWarn(level, this.m_58899_(), player);
        warning.ifPresent(warningLevel -> {
            this.warningLevel = warningLevel;
        });
        return warning.isPresent();
    }

    private void shriek(ServerLevel level, @Nullable Entity entity) {
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SculkShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(true)), 2);
        level.m_186460_(pos, state.m_60734_(), 90);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), WBSoundEvents.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 2.0f, 0.6f + level.f_46441_.nextFloat() * 0.4f);
        for (int i = 0; i < 10; ++i) {
            int delay = i * 5;
            level.m_8767_((ParticleOptions)new ShriekParticleOptions(delay), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + SculkShriekerBlock.TOP_Y, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_142346_(entity, WBGameEvents.SHRIEK.get(), pos);
    }

    private boolean canRespond(ServerLevel level) {
        return (Boolean)this.m_58900_().m_61143_((Property)SculkShriekerBlock.CAN_SUMMON) != false && level.m_46791_() != Difficulty.PEACEFUL && level.m_46469_().m_46207_(WBGameRules.DO_WARDEN_SPAWNING);
    }

    public void tryRespond(ServerLevel level) {
        if (this.canRespond(level) && this.warningLevel > 0) {
            if (!this.trySummonWarden(level)) {
                this.playWardenReplySound();
            }
            Warden.addDarknessToClosePlayers(level, Vec3.m_82512_((Vec3i)this.m_58899_()), null, 40);
        }
    }

    private void playWardenReplySound() {
        SoundEvent sound = (SoundEvent)SOUND_BY_LEVEL.get(this.warningLevel);
        if (sound != null && this.f_58857_ != null) {
            BlockPos pos = this.m_58899_();
            int x = pos.m_123341_() + Mth.m_144928_((Random)this.f_58857_.f_46441_, (int)-10, (int)10);
            int y = pos.m_123342_() + Mth.m_144928_((Random)this.f_58857_.f_46441_, (int)-10, (int)10);
            int z = pos.m_123343_() + Mth.m_144928_((Random)this.f_58857_.f_46441_, (int)-10, (int)10);
            this.f_58857_.m_6263_(null, (double)x, (double)y, (double)z, sound, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(ServerLevel level) {
        return this.warningLevel >= 4 && WardenSpawnHelper.trySpawnMob(WBEntityTypes.WARDEN.get(), MobSpawnType.TRIGGERED, level, this.m_58899_(), 20, 5, 6).isPresent();
    }

    @Override
    public void onSignalSchedule() {
        this.m_6596_();
    }
}

