/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks.entity;

import com.cursedcauldron.wildbackport.client.registry.WBCriteriaTriggers;
import com.cursedcauldron.wildbackport.common.blocks.SculkCatalystBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.entities.access.EntityExperience;
import com.cursedcauldron.wildbackport.common.registry.WBBlockEntities;
import com.cursedcauldron.wildbackport.common.registry.WBGameEvents;
import com.cursedcauldron.wildbackport.common.utils.PositionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.Nullable;

public class SculkCatalystBlockEntity
extends BlockEntity
implements GameEventListener {
    private final BlockPositionSource positionSource;
    private final SculkSpreadManager spreadManager;

    public SculkCatalystBlockEntity(BlockPos pos, BlockState state) {
        super(WBBlockEntities.SCULK_CATALYST.get(), pos, state);
        this.positionSource = new BlockPositionSource(this.f_58858_);
        this.spreadManager = SculkSpreadManager.create();
    }

    public PositionSource m_142460_() {
        return this.positionSource;
    }

    public int m_142078_() {
        return 8;
    }

    public boolean m_142721_(Level level, GameEvent event, @Nullable Entity entity, BlockPos pos) {
        LivingEntity living;
        if (!this.m_58901_() && event == WBGameEvents.ENTITY_DIE.get() && entity instanceof LivingEntity && (living = (LivingEntity)entity) instanceof EntityExperience) {
            EntityExperience mob = (EntityExperience)living;
            if (!mob.isExpDropDisabled()) {
                int charge = mob.getExpToDrop();
                if (!living.m_6162_() && charge > 0) {
                    this.spreadManager.spread(new BlockPos(PositionUtils.relative(PositionUtils.toVec(pos), Direction.UP, 0.5)), charge);
                    LivingEntity attacker = living.m_142581_();
                    if (attacker instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)attacker;
                        DamageSource source = living.m_21225_() == null ? DamageSource.m_19344_((Player)player) : living.m_21225_();
                        WBCriteriaTriggers.KILL_MOB_NEAR_SCULK_CATALYST.m_48104_(player, entity, source);
                    }
                }
                mob.disableExpDrop();
                SculkCatalystBlock.bloom((ServerLevel)level, this.f_58858_, this.m_58900_(), level.m_5822_());
            }
            return true;
        }
        return false;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SculkCatalystBlockEntity catalyst) {
        catalyst.spreadManager.tick((LevelAccessor)level, pos, level.m_5822_(), true);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spreadManager.readTag(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.spreadManager.writeTag(tag);
    }
}

