/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.blocks.MangroveTreeGrower;
import com.cursedcauldron.wildbackport.common.blocks.StateProperties;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MangrovePropaguleBlock
extends SaplingBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)};
    public static final IntegerProperty AGE = StateProperties.AGE_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;

    public MangrovePropaguleBlock(BlockBehaviour.Properties properties) {
        super((AbstractTreeGrower)new MangroveTreeGrower(0.85f), properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55973_, (Comparable)Integer.valueOf(0))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55973_, AGE, WATERLOGGED, HANGING});
    }

    protected boolean m_6266_(BlockState state, BlockGetter block, BlockPos pos) {
        return super.m_6266_(state, block, pos) || state.m_60713_(Blocks.f_50129_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(4));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter block, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(block, pos);
        VoxelShape shape = (Boolean)state.m_61143_((Property)HANGING) == false ? SHAPES[4] : SHAPES[(Integer)state.m_61143_((Property)AGE)];
        return shape.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return MangrovePropaguleBlock.isHanging(state) ? level.m_8055_(pos.m_7494_()).m_60713_(WBBlocks.MANGROVE_LEAVES.get()) : super.m_7898_(state, level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == Direction.UP && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, newState, level, pos, newPos);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!MangrovePropaguleBlock.isHanging(state)) {
            if (random.nextInt(7) == 0) {
                this.m_55980_(level, pos, state, random);
            }
        } else if (!MangrovePropaguleBlock.ageAtMax(state)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public boolean m_7370_(BlockGetter block, BlockPos pos, BlockState state, boolean flag) {
        return !MangrovePropaguleBlock.isHanging(state) || !MangrovePropaguleBlock.ageAtMax(state);
    }

    public boolean m_5491_(Level level, Random random, BlockPos pos, BlockState state) {
        return MangrovePropaguleBlock.isHanging(state) ? !MangrovePropaguleBlock.ageAtMax(state) : super.m_5491_(level, random, pos, state);
    }

    public void m_7719_(ServerLevel level, Random random, BlockPos pos, BlockState state) {
        if (MangrovePropaguleBlock.isHanging(state) && !MangrovePropaguleBlock.ageAtMax(state)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        } else {
            super.m_7719_(level, random, pos, state);
        }
    }

    private static boolean isHanging(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING);
    }

    private static boolean ageAtMax(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 4;
    }

    public static BlockState createPropagule() {
        return MangrovePropaguleBlock.createPropagule(0);
    }

    public static BlockState createPropagule(int age) {
        return (BlockState)((BlockState)WBBlocks.MANGROVE_PROPAGULE.get().m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
    }
}

