/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Tadpole;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrogspawnBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);

    public FrogspawnBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return FrogspawnBlock.mayPlaceOn(reader, pos.m_7495_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        level.m_186460_(pos, (Block)this, FrogspawnBlock.hatchTime(level.m_5822_()));
    }

    private static int hatchTime(Random random) {
        return random.nextInt(3600, 12000);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor access, BlockPos pos, BlockPos neighborPos) {
        return !this.m_7898_(state, (LevelReader)access, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, access, pos, neighborPos);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            this.hatch((Level)level, pos);
        } else {
            this.onHatch(level, pos, random);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.hatch(level, pos);
        }
    }

    private static boolean mayPlaceOn(LevelReader reader, BlockPos pos) {
        FluidState fluidState = reader.m_6425_(pos);
        FluidState topFluidState = reader.m_6425_(pos.m_7494_());
        return fluidState.m_76152_() == Fluids.f_76193_ && topFluidState.m_76152_() == Fluids.f_76191_;
    }

    private void onHatch(ServerLevel level, BlockPos pos, Random random) {
        this.hatch((Level)level, pos);
        level.m_5594_(null, pos, WBSoundEvents.BLOCK_FROGSPAWN_HATCH, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.createTadpole(level, pos, random);
    }

    private void hatch(Level level, BlockPos blockPos) {
        level.m_46961_(blockPos, false);
    }

    private void createTadpole(ServerLevel level, BlockPos pos, Random random) {
        int i = random.nextInt(2, 6);
        for (int index = 1; index <= i; ++index) {
            Tadpole tadpole = (Tadpole)WBEntityTypes.TADPOLE.get().m_20615_((Level)level);
            if (tadpole == null) continue;
            double x = (double)pos.m_123341_() + this.getSpawnOffset(random);
            double z = (double)pos.m_123343_() + this.getSpawnOffset(random);
            int yaw = random.nextInt(1, 361);
            tadpole.m_7678_(x, (double)pos.m_123342_() - 0.5, z, yaw, 0.0f);
            tadpole.m_21530_();
            level.m_7967_((Entity)tadpole);
        }
    }

    private double getSpawnOffset(Random random) {
        return Mth.m_14008_((double)random.nextDouble(), (double)0.2f, (double)0.8f);
    }
}

