/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render;

import com.cursedcauldron.wildbackport.client.render.WardenLayerRenderer;
import com.cursedcauldron.wildbackport.client.render.model.WardenModel;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WardenRenderer
extends MobRenderer<Warden, WardenModel<Warden>> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("wildbackport", "warden"), "main");
    private static final ResourceLocation TEXTURE = new ResourceLocation("wildbackport", "textures/entity/warden/warden.png");
    private static final ResourceLocation BIOLUMINESCENT_LAYER_TEXTURE = new ResourceLocation("wildbackport", "textures/entity/warden/warden_bioluminescent_layer.png");
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("wildbackport", "textures/entity/warden/warden_heart.png");
    private static final ResourceLocation PULSATING_SPOTS_1_TEXTURE = new ResourceLocation("wildbackport", "textures/entity/warden/warden_pulsating_spots_1.png");
    private static final ResourceLocation PULSATING_SPOTS_2_TEXTURE = new ResourceLocation("wildbackport", "textures/entity/warden/warden_pulsating_spots_2.png");

    public WardenRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new WardenModel(ctx.m_174023_(MODEL_LAYER)), 0.9f);
        this.m_115326_(new WardenLayerRenderer<Warden, WardenModel>((RenderLayerParent<Warden, WardenModel>)this, BIOLUMINESCENT_LAYER_TEXTURE, (entity, tickDelta, animationProgress) -> 1.0f, WardenModel::getHeadAndLimbs));
        this.m_115326_(new WardenLayerRenderer<Warden, WardenModel>((RenderLayerParent<Warden, WardenModel>)this, PULSATING_SPOTS_1_TEXTURE, (entity, tickDelta, animationProgress) -> Math.max(0.0f, Mth.m_14089_((float)(animationProgress * 0.045f)) * 0.25f), WardenModel::getBodyHeadAndLimbs));
        this.m_115326_(new WardenLayerRenderer<Warden, WardenModel>((RenderLayerParent<Warden, WardenModel>)this, PULSATING_SPOTS_2_TEXTURE, (entity, tickDelta, animationProgress) -> Math.max(0.0f, Mth.m_14089_((float)(animationProgress * 0.045f + (float)Math.PI)) * 0.25f), WardenModel::getBodyHeadAndLimbs));
        this.m_115326_(new WardenLayerRenderer<Warden, WardenModel>((RenderLayerParent<Warden, WardenModel>)this, TEXTURE, (entity, tickDelta, animationProgress) -> entity.getTendrilPitch(tickDelta), WardenModel::getTendrils));
        this.m_115326_(new WardenLayerRenderer<Warden, WardenModel>((RenderLayerParent<Warden, WardenModel>)this, HEART_TEXTURE, (entity, tickDelta, animationProgress) -> entity.getHeartPitch(tickDelta), WardenModel::getBody));
    }

    public ResourceLocation getTextureLocation(Warden warden) {
        return TEXTURE;
    }
}

