/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.core.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.obscuria.core.ObCoreMod;
import net.obscuria.core.procedures.ManualAboutProcedure;
import net.obscuria.core.procedures.ManualCreditsProcedure;
import net.obscuria.core.procedures.ManualDiscordProcedure;
import net.obscuria.core.procedures.ManualModListProcedure;
import net.obscuria.core.procedures.ManualPatreonProcedure;
import net.obscuria.core.procedures.ManualWikiProcedure;
import net.obscuria.core.procedures.ManualYouTubeProcedure;
import net.obscuria.core.world.inventory.ManualHomeMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ManualHomeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ManualHomeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ManualHomeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ManualHomeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ManualHomeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ManualHomeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = ManualHomeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ManualAboutProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ManualCreditsProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ManualDiscordProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ManualModListProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ManualYouTubeProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ManualWikiProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ManualPatreonProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ObCoreMod.addNetworkMessage(ManualHomeButtonMessage.class, ManualHomeButtonMessage::buffer, ManualHomeButtonMessage::new, ManualHomeButtonMessage::handler);
    }
}

