/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.core.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.obscuria.core.world.features.ores.DeepslatePlatinumOreFeature;
import net.obscuria.core.world.features.ores.MagicCrystalClusterFeature;
import net.obscuria.core.world.features.ores.RawPlatinumBlockFeature;

@Mod.EventBusSubscriber
public class ObCoreModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"ob_core");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> MAGIC_CRYSTAL_CLUSTER = ObCoreModFeatures.register("magic_crystal_cluster", MagicCrystalClusterFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, MagicCrystalClusterFeature.GENERATE_BIOMES, MagicCrystalClusterFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DEEPSLATE_PLATINUM_ORE = ObCoreModFeatures.register("deepslate_platinum_ore", DeepslatePlatinumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DeepslatePlatinumOreFeature.GENERATE_BIOMES, DeepslatePlatinumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAW_PLATINUM_BLOCK = ObCoreModFeatures.register("raw_platinum_block", RawPlatinumBlockFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RawPlatinumBlockFeature.GENERATE_BIOMES, RawPlatinumBlockFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

