/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.core.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.obscuria.core.entity.AncientPaladinEntity;
import net.obscuria.core.entity.FlyingAxeEntity;
import net.obscuria.core.entity.HildaEntity;
import net.obscuria.core.entity.ObsidianShardEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ObCoreModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"ob_core");
    public static final RegistryObject<EntityType<HildaEntity>> HILDA = ObCoreModEntities.register("hilda", EntityType.Builder.m_20704_(HildaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HildaEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<AncientPaladinEntity>> ANCIENT_PALADIN = ObCoreModEntities.register("ancient_paladin", EntityType.Builder.m_20704_(AncientPaladinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(AncientPaladinEntity::new).m_20719_().m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<ObsidianShardEntity>> OBSIDIAN_SHARD = ObCoreModEntities.register("obsidian_shard", EntityType.Builder.m_20704_(ObsidianShardEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ObsidianShardEntity::new).m_20719_().m_20699_(0.1f, 0.4f));
    public static final RegistryObject<EntityType<FlyingAxeEntity>> FLYING_AXE = ObCoreModEntities.register("projectile_flying_axe", EntityType.Builder.m_20704_(FlyingAxeEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FlyingAxeEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HildaEntity.init();
            AncientPaladinEntity.init();
            ObsidianShardEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HILDA.get(), HildaEntity.createAttributes().m_22265_());
        event.put((EntityType)ANCIENT_PALADIN.get(), AncientPaladinEntity.createAttributes().m_22265_());
        event.put((EntityType)OBSIDIAN_SHARD.get(), ObsidianShardEntity.createAttributes().m_22265_());
    }
}

