/*
 * Decompiled with CFR 0.152.
 */
package net.obscuria.core;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class Hekate {
    public static float idle(float degreeSwing, float degreeBase, float speed, float offset, float ageInTicks, float mod) {
        degreeSwing = degreeSwing * (float)Math.PI / 180.0f;
        degreeBase = degreeBase * (float)Math.PI / 180.0f;
        float result = (degreeSwing * Mth.m_14089_((float)(ageInTicks * speed + offset * 6.283f)) + degreeBase) * mod;
        return result;
    }

    public static float move(boolean invert, float degreeSwing, float degreeBase, float speed, float offset, float limbSwing, float mod) {
        degreeSwing = degreeSwing * (float)Math.PI / 180.0f;
        degreeBase = degreeBase * (float)Math.PI / 180.0f;
        float invertValue = invert ? -1.0f : 1.0f;
        float result = (invertValue * mod * degreeSwing * Mth.m_14089_((float)(limbSwing * speed + offset * 6.283f)) + degreeBase) * mod;
        return result;
    }

    public static float fixed(float degree, float mod) {
        degree = degree * (float)Math.PI / 180.0f;
        return degree * mod;
    }

    public static float getHeadYaw(float yaw, float mod) {
        return yaw / 57.295776f * mod;
    }

    public static float getModifier(float ageInTicks, float speed, float offset) {
        return 0.5f + Mth.m_14089_((float)(ageInTicks * speed + offset * 6.283f)) * 0.5f;
    }

    public static float getFrame(Entity e, String anim, double speed, double durationTick, double endTick) {
        double frame = 0.0;
        if (e.getPersistentData().m_128471_(anim + "Anim")) {
            double delta = e.getPersistentData().m_128459_("hekateEntity");
            double currentTick = e.getPersistentData().m_128459_(anim + "Tick") + 1.0 * delta;
            frame = e.getPersistentData().m_128459_(anim + "Frame");
            if (currentTick < durationTick) {
                frame += (1.0 - frame) * (speed * delta);
            } else if (currentTick > endTick) {
                e.getPersistentData().m_128379_(anim + "Anim", false);
                frame = 0.0;
                currentTick = 0.0;
            } else {
                frame += (0.0 - frame) * (speed * delta);
            }
            e.getPersistentData().m_128347_(anim + "Tick", currentTick);
            e.getPersistentData().m_128347_(anim + "Frame", frame);
        }
        return (float)frame;
    }

    public static void updateRenderer(Entity e) {
        e.getPersistentData().m_128347_("hekateRenderer", e.getPersistentData().m_128459_("hekateRenderer") + 1.0);
    }

    public static void updateEntity(Entity e) {
        e.getPersistentData().m_128347_("hekateEntity", 60.0 / (e.getPersistentData().m_128459_("hekateRenderer") * 20.0));
        e.getPersistentData().m_128347_("hekateRenderer", 0.0);
    }

    public static float setIdleModifier(float limbSwingAmount, float mod) {
        return 1.0f - limbSwingAmount * mod < 0.0f ? 0.0f : 1.0f - limbSwingAmount * mod;
    }

    public static float setMoveModifier(float limbSwingAmount, float mod) {
        return limbSwingAmount * mod > 1.0f ? 1.0f : limbSwingAmount * mod;
    }

    public static boolean isPrepared(Entity e) {
        ItemStack itemStack;
        if (e instanceof LivingEntity) {
            LivingEntity _livEnt = (LivingEntity)e;
            itemStack = _livEnt.m_21206_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack.m_41613_() > 0;
    }

    public static void playPrepared(Entity e) {
        ItemStack itemStack;
        CompoundTag compoundTag = e.getPersistentData();
        if (e instanceof LivingEntity) {
            LivingEntity _livEnt = (LivingEntity)e;
            itemStack = _livEnt.m_21206_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        compoundTag.m_128379_(itemStack.m_41611_().getString() + "Anim", true);
    }

    public static void play(String anim, Entity e) {
        e.getPersistentData().m_128379_(anim + "Anim", true);
    }
}

