/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.world.structures.AbstractBaseStructure;
import com.craisinlord.integrated_api.world.structures.configs.AdvancedConfig;
import com.craisinlord.integrated_api.world.structures.pieces.PieceLimitedJigsawManager;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class AdvancedJigsawStructure<C extends AdvancedConfig>
extends AbstractBaseStructure<C> {
    public AdvancedJigsawStructure(Codec<C> codec) {
        super(codec, AdvancedJigsawStructure::isAdvancedFeatureChunk, AdvancedJigsawStructure::generateAdvancedPieces);
    }

    public AdvancedJigsawStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends AdvancedConfig> boolean isAdvancedFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        AdvancedConfig config = (AdvancedConfig)context.f_197356_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (int curChunkX = chunkPos.f_45578_ - config.biomeRadius; curChunkX <= chunkPos.f_45578_ + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.biomeRadius; curChunkZ <= chunkPos.f_45579_ + config.biomeRadius; ++curChunkZ) {
                    WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                    random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
                    int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
                    if (context.f_197358_().test(context.f_197353_().m_203407_(curChunkX << 2, structureStartHeight >> 2, curChunkZ << 2, context.f_197352_().m_183403_()))) continue;
                    return false;
                }
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends AdvancedConfig> Optional<PieceGenerator<CC>> generateAdvancedPieces(PieceGeneratorSupplier.Context<CC> context) {
        int bottomClipOff;
        int topClipOff;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        AdvancedConfig config = (AdvancedConfig)context.f_197356_();
        if (config.maxY - config.minY <= 0) {
            IntegratedAPI.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((ResourceKey)config.startPool.m_203543_().get()).m_135782_());
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.m_122175_(Direction.UP, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + config.verticalRange.get();
            bottomClipOff = structureStartHeight - config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), (BlockPos)blockpos, false, false, topClipOff, bottomClipOff, !config.rotationFixed, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {});
    }
}

