/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.world.structures.AdvancedJigsawStructure;
import com.craisinlord.integrated_api.world.structures.configs.AdvancedDistanceConfig;
import com.craisinlord.integrated_api.world.structures.pieces.PieceLimitedJigsawManager;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class AdvancedDistanceJigsawStructure<C extends AdvancedDistanceConfig>
extends AdvancedJigsawStructure<C> {
    public AdvancedDistanceJigsawStructure(Codec<C> codec) {
        super(codec, AdvancedDistanceJigsawStructure::isDistanceFeatureChunk, AdvancedDistanceJigsawStructure::generateDistancePieces);
    }

    public AdvancedDistanceJigsawStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends AdvancedDistanceConfig> boolean isDistanceFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        int zBlockPos;
        AdvancedDistanceConfig config = (AdvancedDistanceConfig)context.f_197356_();
        int radius = config.distanceFromOrigin;
        int xBlockPos = context.f_197355_().m_45604_();
        return xBlockPos * xBlockPos + (zBlockPos = context.f_197355_().m_45605_()) * zBlockPos > radius * radius && AdvancedDistanceJigsawStructure.isAdvancedFeatureChunk(context);
    }

    public static <CC extends AdvancedDistanceConfig> Optional<PieceGenerator<CC>> generateDistancePieces(PieceGeneratorSupplier.Context<CC> context) {
        int bottomClipOff;
        int topClipOff;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        AdvancedDistanceConfig config = (AdvancedDistanceConfig)context.f_197356_();
        if (config.maxY - config.minY <= 0) {
            IntegratedAPI.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((ResourceKey)config.startPool.m_203543_().get()).m_135782_());
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.m_122175_(Direction.UP, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), (BlockPos)blockpos, false, false, topClipOff, bottomClipOff, config.rotationFixed, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            Optional<PoolElementStructurePiece> lowestPiece = pieces.stream().min(Comparator.comparingInt(p -> p.m_73547_().m_162396_()));
            int minY = lowestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.m_73547_().m_162396_()).orElseGet(() -> ((BlockPos.MutableBlockPos)blockpos).m_123342_());
            if (minY < context.f_197352_().m_142062_()) {
                int newOffset = context.f_197352_().m_142062_() - minY;
                for (StructurePiece piece : pieces) {
                    piece.m_6324_(0, newOffset, 0);
                }
            }
        });
    }
}

