/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.processors;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IntegratedAPIProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerRandomizingProcessor
extends StructureProcessor {
    public static final Codec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("integrated_api_spawner_resourcelocation").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.intAPISpawnerResourcelocation)).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final ResourceLocation intAPISpawnerResourcelocation;

    private SpawnerRandomizingProcessor(ResourceLocation intAPISpawnerResourcelocation) {
        this.intAPISpawnerResourcelocation = intAPISpawnerResourcelocation;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.f_74676_.m_60734_() instanceof SpawnerBlock) {
            BlockPos worldPos = structureBlockInfoWorld.f_74675_;
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.setSeed(worldPos.m_121878_() * (long)worldPos.m_123342_());
            CompoundTag spawnerNBT = this.SetMobSpawnerEntity((Random)random, structureBlockInfoWorld.f_74677_);
            if (spawnerNBT == null) {
                return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.f_50016_.m_49966_(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, structureBlockInfoWorld.f_74676_, spawnerNBT);
        }
        return structureBlockInfoWorld;
    }

    private CompoundTag SetMobSpawnerEntity(Random random, CompoundTag nbt) {
        EntityType<?> entity = IntegratedAPI.mobSpawnerManager.getSpawnerMob(this.intAPISpawnerResourcelocation, random);
        if (entity != null) {
            if (nbt != null) {
                CompoundTag entityTag;
                CompoundTag spawnDataTag = nbt.m_128469_("SpawnData");
                if (spawnDataTag.m_128456_()) {
                    spawnDataTag = new CompoundTag();
                    nbt.m_128365_("SpawnData", (Tag)spawnDataTag);
                }
                if ((entityTag = nbt.m_128469_("entity")).m_128456_()) {
                    entityTag = new CompoundTag();
                    spawnDataTag.m_128365_("entity", (Tag)entityTag);
                }
                entityTag.m_128359_("id", ForgeRegistries.ENTITIES.getKey(entity).toString());
                CompoundTag spawnEntityDataTag = new CompoundTag();
                spawnEntityDataTag.m_128359_("id", ForgeRegistries.ENTITIES.getKey(entity).toString());
                CompoundTag spawnPotentialDataEntryTag = new CompoundTag();
                spawnPotentialDataEntryTag.m_128365_("entity", (Tag)spawnEntityDataTag);
                CompoundTag spawnPotentialEntryTag = new CompoundTag();
                spawnPotentialEntryTag.m_128365_("data", (Tag)spawnPotentialDataEntryTag);
                spawnPotentialEntryTag.m_128365_("weight", (Tag)IntTag.m_128679_((int)1));
                nbt.m_128365_("SpawnPotentials", (Tag)new ListTag());
                return nbt;
            }
            CompoundTag compound = new CompoundTag();
            compound.m_128376_("Delay", (short)20);
            compound.m_128376_("MinSpawnDelay", (short)200);
            compound.m_128376_("MaxSpawnDelay", (short)800);
            compound.m_128376_("SpawnCount", (short)4);
            compound.m_128376_("MaxNearbyEntities", (short)6);
            compound.m_128376_("RequiredPlayerRange", (short)16);
            compound.m_128376_("SpawnRange", (short)4);
            CompoundTag spawnDataEntity = new CompoundTag();
            spawnDataEntity.m_128359_("id", ForgeRegistries.ENTITIES.getKey(entity).toString());
            CompoundTag spawnData = new CompoundTag();
            spawnData.m_128365_("entity", (Tag)spawnDataEntity);
            compound.m_128365_("SpawnData", (Tag)spawnData);
            CompoundTag entityData = new CompoundTag();
            entityData.m_128359_("id", ForgeRegistries.ENTITIES.getKey(entity).toString());
            CompoundTag spawnPotentialData = new CompoundTag();
            spawnPotentialData.m_128365_("entity", (Tag)entityData);
            CompoundTag listEntry = new CompoundTag();
            listEntry.m_128365_("data", (Tag)spawnPotentialData);
            listEntry.m_128405_("weight", 1);
            compound.m_128365_("SpawnPotentials", (Tag)new ListTag());
            return compound;
        }
        return null;
    }

    protected StructureProcessorType<?> m_6953_() {
        return IntegratedAPIProcessors.SPAWNER_RANDOMIZING_PROCESSOR;
    }
}

