/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.maptrades;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.misc.maptrades.StructureSpecificMaps;
import com.craisinlord.integrated_api.misc.maptrades.VillagerMapObj;
import com.craisinlord.integrated_api.misc.maptrades.WanderingTraderMapObj;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class StructureMapTradesEvents {
    private StructureMapTradesEvents() {
    }

    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        ResourceLocation currentVillager = ForgeRegistries.PROFESSIONS.getKey((IForgeRegistryEntry)event.getType());
        if (currentVillager != null && IntegratedAPI.structureMapManager.VILLAGER_MAP_TRADES.containsKey(currentVillager.toString())) {
            for (VillagerMapObj mapTrade : IntegratedAPI.structureMapManager.VILLAGER_MAP_TRADES.get(currentVillager.toString())) {
                MapDecoration.Type icon;
                try {
                    icon = MapDecoration.Type.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error((Object)e);
                    icon = MapDecoration.Type.MANSION;
                }
                ((List)event.getTrades().get(mapTrade.tradeLevel)).add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }

    public static void onWandererTradesEvent(WandererTradesEvent event) {
        for (Map.Entry<WanderingTraderMapObj.TRADE_TYPE, List<WanderingTraderMapObj>> tradeEntry : IntegratedAPI.structureMapManager.WANDERING_TRADER_MAP_TRADES.entrySet()) {
            for (WanderingTraderMapObj mapTrade : tradeEntry.getValue()) {
                MapDecoration.Type icon;
                try {
                    icon = MapDecoration.Type.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error((Object)e);
                    icon = MapDecoration.Type.MANSION;
                }
                if (tradeEntry.getKey() == WanderingTraderMapObj.TRADE_TYPE.RARE) {
                    event.getRareTrades().add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
                    continue;
                }
                if (tradeEntry.getKey() != WanderingTraderMapObj.TRADE_TYPE.COMMON) continue;
                event.getGenericTrades().add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }
}

