/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc;

import com.craisinlord.integrated_api.IntegratedAPI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public final class BiomeDimensionAllowDisallow {
    public static final Map<ResourceLocation, List<Pattern>> DIMENSION_DISALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> DIMENSION_ALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> BIOME_ALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> BIOME_DISALLOW = new HashMap<ResourceLocation, List<Pattern>>();

    private BiomeDimensionAllowDisallow() {
    }

    private static void setupMap(Map<ResourceLocation, List<Pattern>> mapToFillWithPatterns, Map<String, String> configMap, String errorMsg) {
        for (Map.Entry<String, String> configMapEntry : configMap.entrySet()) {
            List<String> parsedValues = Arrays.stream(configMapEntry.getValue().split(",")).map(String::trim).collect(Collectors.toList());
            ResourceLocation worldgenObjectID = new ResourceLocation(configMapEntry.getKey());
            if (configMapEntry.getKey().equals("all")) {
                mapToFillWithPatterns.values().forEach(patternList -> parsedValues.forEach(pattern -> patternList.add(Pattern.compile(pattern))));
                continue;
            }
            if (mapToFillWithPatterns.containsKey(worldgenObjectID)) {
                parsedValues.forEach(patternList -> ((List)mapToFillWithPatterns.get(worldgenObjectID)).add(Pattern.compile(patternList)));
                continue;
            }
            IntegratedAPI.LOGGER.warn("Integrated API: Unknown key {} was found in the {} config. Skipping that entry...", (Object)worldgenObjectID, (Object)errorMsg);
        }
    }
}

