/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api;

import com.craisinlord.integrated_api.misc.maptrades.StructureMapManager;
import com.craisinlord.integrated_api.misc.maptrades.StructureMapTradesEvents;
import com.craisinlord.integrated_api.misc.mobspawners.MobSpawnerManager;
import com.craisinlord.integrated_api.misc.pooladditions.PoolAdditionMerger;
import com.craisinlord.integrated_api.misc.structurepiececounter.JSONConditionsRegistry;
import com.craisinlord.integrated_api.misc.structurepiececounter.StructurePieceCountsManager;
import com.craisinlord.integrated_api.modinit.IntegratedAPIPlacements;
import com.craisinlord.integrated_api.modinit.IntegratedAPIPredicates;
import com.craisinlord.integrated_api.modinit.IntegratedAPIProcessors;
import com.craisinlord.integrated_api.modinit.IntegratedAPIStructures;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.world.structures.IFJigsawStructure;
import java.nio.file.Path;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="integrated_api")
public class IntegratedAPI {
    public static final String MODID = "integrated_api";
    public static final Logger LOGGER = LogManager.getLogger();
    public static StructureMapManager structureMapManager = new StructureMapManager();
    public static StructurePieceCountsManager structurePieceCountsManager = new StructurePieceCountsManager();
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();

    public IntegratedAPI() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        JSONConditionsRegistry.registerTestJSONCondition();
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("integrated_api-forge"), (String)"integrated_api-forge");
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::registerDatapackListener);
        forgeBus.addListener(StructureMapTradesEvents::onVillagerTradesEvent);
        forgeBus.addListener(StructureMapTradesEvents::onWandererTradesEvent);
        forgeBus.addListener(PoolAdditionMerger::mergeAdditionPools);
        modEventBus.addListener(this::setup);
        IntegratedAPIStructures.STRUCTURE_FEATURES.register(modEventBus);
        IFJigsawStructure.isIFOn = ModList.get().isLoaded("iceandfire");
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            IntegratedAPIProcessors.registerProcessors();
            IntegratedAPIPredicates.registerPredicates();
            IntegratedAPIPlacements.registerPlacements();
            IntegratedAPIStructures.setupStructures();
        });
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)structureMapManager);
        event.addListener((PreparableReloadListener)structurePieceCountsManager);
        event.addListener((PreparableReloadListener)mobSpawnerManager);
    }

    public void serverStarted(ServerStartedEvent event) {
        GeneralUtils.clearCache();
    }
}

