/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.server;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;

public class ItemPhysicServer {
    public static int tempDroppower = 1;
    private static Field fluidOnEyesField = ObfuscationReflectionHelper.findField(Entity.class, (String)"f_19799_");
    public static final ThreadLocal<Fluid> fluid = new ThreadLocal();
    private static Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"f_31985_");
    private static Field healthField = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"f_31987_");
    private static Field randField = ObfuscationReflectionHelper.findField(Entity.class, (String)"f_19796_");
    private static Method markHurtMethod = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"m_5834_", (Class[])new Class[0]);
    public static List<ServerPlayer> toCancel = new ArrayList<ServerPlayer>();

    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ItemPhysicServer.class);
    }

    @SubscribeEvent
    public static void onDespawn(ItemExpireEvent event) {
        if (ItemPhysic.CONFIG.general.despawnItem == -1) {
            try {
                age.set(event.getEntityItem(), 1);
                event.setCanceled(true);
                event.setExtraLife(0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onToos(ItemTossEvent event) {
        event.getEntityItem().m_20256_(event.getEntityItem().m_20184_().m_82490_((double)tempDroppower));
        tempDroppower = 1;
    }

    public static void updatePre(ItemEntity item) {
        ItemStack stack = item.m_32055_();
        fluid.set(CommonPhysic.getFluid(item));
        if (fluid.get() == null) {
            if (!item.m_20068_()) {
                item.m_20256_(item.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            return;
        }
        double density = (double)fluid.get().getAttributes().getDensity() / 1000.0;
        double speed = -1.0 / density * 0.01;
        if (ItemPhysic.CONFIG.general.swimmingItems.canPass(stack)) {
            speed = 0.1;
        }
        if (item.m_20184_().f_82480_ > 0.0 && speed < item.m_20184_().f_82480_) {
            return;
        }
        double speedreduction = (speed - item.m_20184_().f_82480_) / 2.0;
        double maxSpeedReduction = 0.1;
        if (speedreduction < -maxSpeedReduction) {
            speedreduction = -maxSpeedReduction;
        }
        if (speedreduction > maxSpeedReduction) {
            speedreduction = maxSpeedReduction;
        }
        item.m_20256_(item.m_20184_().m_82520_(0.0, speedreduction, 0.0));
        try {
            float f = item.m_20192_() - 0.11111111f;
            if ((item.m_20077_() && item.m_204036_(FluidTags.f_13132_) > (double)f || item.m_6060_()) && ItemPhysic.CONFIG.general.burningItems.canPass(item.m_32055_())) {
                Random rand = (Random)randField.get(item);
                item.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + rand.nextFloat() * 0.4f);
                for (int i = 0; i < 100; ++i) {
                    item.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, item.m_20185_(), item.m_20186_(), item.m_20189_(), (double)rand.nextFloat() * 0.1 - 0.05, 0.2 * rand.nextDouble(), (double)rand.nextFloat() * 0.1 - 0.05);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static boolean updateFluidHeightAndDoFluidPushing(ItemEntity item, TagKey<Fluid> fluidTag, double p_210500_2_) {
        double size = -0.001;
        if (fluidTag == FluidTags.f_13131_ && ItemPhysic.CONFIG.general.swimmingItems.canPass(item.m_32055_())) {
            size = 0.3;
        }
        if (item.m_146899_()) {
            return false;
        }
        AABB aabb = item.m_142469_().m_82400_(size);
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)aabb.f_82292_);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        double d0 = 0.0;
        boolean flag = item.m_6063_();
        boolean flag1 = false;
        Vec3 vec3 = Vec3.f_82478_;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d1;
                    blockpos$mutableblockpos.m_122178_(l1, i2, j2);
                    FluidState fluidstate = item.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(fluidTag) || !((d1 = (double)((float)i2 + fluidstate.m_76155_((BlockGetter)item.f_19853_, (BlockPos)blockpos$mutableblockpos))) >= aabb.f_82289_)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - aabb.f_82289_, d0);
                    if (!flag) continue;
                    Vec3 vec31 = fluidstate.m_76179_((BlockGetter)item.f_19853_, (BlockPos)blockpos$mutableblockpos);
                    if (d0 < 0.4) {
                        vec31 = vec31.m_82490_(d0);
                    }
                    vec3 = vec3.m_82549_(vec31);
                    ++k1;
                }
            }
        }
        if (vec3.m_82553_() > 0.0) {
            if (k1 > 0) {
                vec3 = vec3.m_82490_(1.0 / (double)k1);
            }
            vec3 = vec3.m_82541_();
            Vec3 vec32 = item.m_20184_();
            vec3 = vec3.m_82490_(p_210500_2_ * 1.0);
            if (Math.abs(vec32.f_82479_) < 0.003 && Math.abs(vec32.f_82481_) < 0.003 && vec3.m_82553_() < 0.0045) {
                vec3 = vec3.m_82541_().m_82490_(0.0045);
            }
            item.m_20256_(item.m_20184_().m_82549_(vec3));
        }
        try {
            Set map = (Set)fluidOnEyesField.get(item);
            map.add(fluidTag);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return flag1;
    }

    public static boolean fireImmune(ItemEntity item) {
        return !ItemPhysic.CONFIG.general.burningItems.canPass(item.m_32055_());
    }

    public static void update(ItemEntity item, float f) {
        if (fluid.get() == null) {
            item.m_20256_(item.m_20184_().m_82542_((double)f, 0.98, (double)f));
            if (item.m_20096_() && item.m_20184_().f_82480_ < 0.0) {
                item.m_20256_(item.m_20184_().m_82542_(1.0, -0.5, 1.0));
            }
        } else {
            item.m_20256_(item.m_20184_().m_82542_(1.0 / ((double)fluid.get().getAttributes().getDensity() / 900.0), 1.0, 1.0 / ((double)fluid.get().getAttributes().getDensity() / 900.0)));
        }
        if (ItemPhysic.CONFIG.general.despawnItem != -1 && item.lifespan == 6000 && item.lifespan != ItemPhysic.CONFIG.general.despawnItem) {
            item.lifespan = ItemPhysic.CONFIG.general.despawnItem;
        }
    }

    public static void checkFallDamage(ItemEntity item, double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn && item.f_19789_ > 0.0f && ItemPhysic.CONFIG.general.fallSounds) {
            item.m_5496_(SoundEvents.f_12640_, Math.min(1.0f, item.f_19789_ / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
    }

    public static boolean playerTouch(ItemEntity item, Player player) {
        if (ItemPhysic.CONFIG.pickup.customPickup && !player.m_20163_() || !ItemPhysic.CONFIG.pickup.pickupWhenSneaking) {
            return true;
        }
        return item.f_19853_.f_46443_ || item.m_32063_();
    }

    public static void playerTouch(ItemEntity entity, Player player, boolean needsSneak) {
        if (ItemPhysic.CONFIG.pickup.customPickup && needsSneak && (!player.m_6047_() || !ItemPhysic.CONFIG.pickup.pickupWhenSneaking)) {
            return;
        }
        if (!entity.f_19853_.f_46443_) {
            if (!ItemPhysic.CONFIG.pickup.customPickup && entity.m_32063_()) {
                return;
            }
            ItemStack itemstack = entity.m_32055_();
            Item item = itemstack.m_41720_();
            int i = itemstack.m_41613_();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)entity, (Player)player);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.m_41777_();
            try {
                if (!(entity.m_32063_() && !ItemPhysic.CONFIG.pickup.customPickup || entity.m_32056_() != null && entity.lifespan - age.getInt(entity) > 200 && !entity.m_32056_().equals(player.m_142081_()) || hook != 1 && i > 0 && !player.m_150109_().m_36054_(itemstack))) {
                    copy.m_41764_(copy.m_41613_() - entity.m_32055_().m_41613_());
                    ForgeEventFactory.firePlayerItemPickupEvent((Player)player, (ItemEntity)entity, (ItemStack)copy);
                    player.m_7938_((Entity)entity, i);
                    if (itemstack.m_41619_()) {
                        entity.m_146870_();
                        itemstack.m_41764_(i);
                    }
                    player.m_6278_(Stats.f_12984_.m_12902_((Object)item), i);
                    player.m_21053_(entity);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public static InteractionResult interact(ItemEntity item, Player player, InteractionHand hand) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            ItemPhysicServer.playerTouch(item, player, false);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean hurt(ItemEntity item, DamageSource source, float amount) {
        if (item.f_19853_.f_46443_ || item.m_146910_()) {
            return false;
        }
        if (item.m_6673_(source)) {
            return false;
        }
        if (!item.m_32055_().m_41619_() && ItemPhysic.CONFIG.general.undestroyableItems.canPass(item.m_32055_())) {
            return false;
        }
        if (!item.m_32055_().m_41619_() && item.m_32055_().m_41720_() == Items.f_42686_ && source.m_19372_()) {
            return false;
        }
        if (!item.m_32055_().m_41720_().m_41386_(source)) {
            return false;
        }
        if (!(source != DamageSource.f_19308_ && source != DamageSource.f_19307_ && source != DamageSource.f_19305_ || ItemPhysic.CONFIG.general.burningItems.canPass(item.m_32055_()))) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        try {
            markHurtMethod.invoke((Object)item, new Object[0]);
            healthField.setInt(item, (int)((float)healthField.getInt(item) - amount));
            item.m_146852_(GameEvent.f_157808_, source.m_7639_());
            if (healthField.getInt(item) <= 0) {
                item.m_32055_().onDestroyed(item, source);
                item.m_146870_();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
        return true;
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload event) {
        toCancel.removeIf(x -> x.f_19853_ == event.getWorld());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if ((event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteract) && !event.getPlayer().f_19853_.f_46443_ && toCancel.contains(event.getPlayer())) {
            toCancel.remove(event.getPlayer());
            event.setCanceled(true);
        }
    }
}

