/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.itemphysic.ItemPhysic;

public class CommonPhysic {
    public static Fluid getFluid(ItemEntity item) {
        return CommonPhysic.getFluid(item, false);
    }

    public static Fluid getFluid(ItemEntity item, boolean below) {
        FluidState state;
        Fluid fluid;
        if (item.f_19853_ == null) {
            return null;
        }
        double d0 = item.m_20186_();
        BlockPos pos = item.m_142538_();
        if (below) {
            pos = pos.m_7495_();
        }
        if ((fluid = (state = item.f_19853_.m_6425_(pos)).m_76152_()) == null || fluid.getAttributes().getDensity() == 0) {
            return null;
        }
        if (below) {
            return fluid;
        }
        double filled = state.m_76155_((BlockGetter)item.f_19853_, pos);
        if (d0 - (double)pos.m_123342_() - 0.2 <= filled) {
            return fluid;
        }
        return null;
    }

    public static double getReachDistance(Player player) {
        if (ItemPhysic.CONFIG.pickup.maximumPickupRange != 5.0f) {
            return ItemPhysic.CONFIG.pickup.maximumPickupRange;
        }
        return PlayerUtils.getReach((Player)player);
    }

    public static HitResult getEntityItem(Player player, Vec3 position, Vec3 look, double distance) {
        float f1 = 3.0f;
        Vec3 include = look.m_82546_(position);
        List list = player.f_19853_.m_45933_((Entity)player, player.m_142469_().m_82363_(include.f_82479_, include.f_82480_, include.f_82481_).m_82363_((double)f1, (double)f1, (double)f1));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof ItemEntity)) continue;
            AABB axisalignedbb = entity.m_142469_().m_82400_(0.2);
            Optional vec = axisalignedbb.m_82371_(position, look);
            if (vec.isPresent()) {
                return new EntityHitResult(entity, (Vec3)vec.get());
            }
            if (!axisalignedbb.m_82390_(position)) continue;
            return new EntityHitResult(entity);
        }
        return null;
    }
}

