/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;

@OnlyIn(value=Dist.CLIENT)
public class ItemPhysicClient {
    public static KeyMapping pickup = new KeyMapping("key.pickup.item", InputConstants.f_84822_.m_84873_(), "key.categories.gameplay");
    public static Minecraft mc;
    private static final Field skipPhysicRenderer;
    public static long lastTickTime;
    public static int throwingPower;
    private static Field stuckSpeedMultiplierField;

    public static void init(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyMapping)pickup);
        mc = Minecraft.m_91087_();
        MinecraftForge.EVENT_BUS.register(ItemPhysicClient.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            lastTickTime = System.nanoTime();
        }
        if (event.phase == TickEvent.Phase.END && ItemPhysicClient.mc.f_91080_ == null) {
            ItemPhysicClient.renderTickFull();
        }
    }

    public static boolean render(ItemEntity entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, ItemRenderer itemRenderer, Random rand) {
        boolean applyEffects;
        Vec3 motionMultiplier;
        try {
            if (entity.m_32059_() == 0 || skipPhysicRenderer.getBoolean(entity) || ItemPhysic.CONFIG.rendering.vanillaRendering) {
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        pose.m_85836_();
        ItemStack itemstack = entity.m_32055_();
        rand.setSeed(itemstack.m_41619_() ? 187L : (long)(Item.m_41393_((Item)itemstack.m_41720_()) + itemstack.m_41773_()));
        BakedModel bakedmodel = itemRenderer.m_174264_(itemstack, entity.f_19853_, (LivingEntity)null, entity.m_142049_());
        boolean flag = bakedmodel.m_7539_();
        int j = ItemPhysicClient.getModelCount(itemstack);
        float rotateBy = (float)(System.nanoTime() - lastTickTime) / 2.0E8f * ItemPhysic.CONFIG.rendering.rotateSpeed;
        if (mc.m_91104_()) {
            rotateBy = 0.0f;
        }
        if ((motionMultiplier = ItemPhysicClient.getStuckSpeedMultiplier((Entity)entity)) != null && motionMultiplier.m_82556_() > 0.0) {
            rotateBy = (float)((double)rotateBy * (motionMultiplier.f_82479_ * 0.2));
        }
        pose.m_85845_(Vector3f.f_122223_.m_122270_(1.5707964f));
        pose.m_85845_(Vector3f.f_122227_.m_122270_(entity.m_146908_()));
        boolean bl = applyEffects = entity.m_32059_() != 0 && (flag || ItemPhysicClient.mc.f_91066_ != null);
        if (applyEffects) {
            if (flag) {
                if (!entity.m_20096_()) {
                    rotateBy *= 2.0f;
                    Fluid fluid = CommonPhysic.getFluid(entity);
                    if (fluid == null) {
                        fluid = CommonPhysic.getFluid(entity, true);
                    }
                    if (fluid != null) {
                        rotateBy /= (float)(fluid.getAttributes().getDensity() / 1000 * 10);
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                } else if (ItemPhysic.CONFIG.rendering.oldRotation) {
                    for (int side = 0; side < 4; ++side) {
                        double rotation = side * 90;
                        double range = 5.0;
                        if (!((double)entity.m_146909_() > rotation - range) || !((double)entity.m_146909_() < rotation + range)) continue;
                        entity.m_146926_((float)rotation);
                    }
                    if (entity.m_146909_() != 0.0f && entity.m_146909_() != 90.0f && entity.m_146909_() != 180.0f && entity.m_146909_() != 270.0f) {
                        double Abstand0 = Math.abs(entity.m_146909_());
                        double Abstand90 = Math.abs(entity.m_146909_() - 90.0f);
                        double Abstand180 = Math.abs(entity.m_146909_() - 180.0f);
                        double Abstand270 = Math.abs(entity.m_146909_() - 270.0f);
                        if (Abstand0 <= Abstand90 && Abstand0 <= Abstand180 && Abstand0 <= Abstand270) {
                            if (entity.m_146909_() < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand90 < Abstand0 && Abstand90 <= Abstand180 && Abstand90 <= Abstand270) {
                            if (entity.m_146909_() - 90.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand180 < Abstand90 && Abstand180 < Abstand0 && Abstand180 <= Abstand270) {
                            if (entity.m_146909_() - 180.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                        if (Abstand270 < Abstand90 && Abstand270 < Abstand180 && Abstand270 < Abstand0) {
                            if (entity.m_146909_() - 270.0f < 0.0f) {
                                entity.m_146926_(entity.m_146909_() + rotateBy);
                            } else {
                                entity.m_146926_(entity.m_146909_() - rotateBy);
                            }
                        }
                    }
                }
            } else if (!(entity == null || Double.isNaN(entity.m_20185_()) || Double.isNaN(entity.m_20186_()) || Double.isNaN(entity.m_20189_()) || entity.f_19853_ == null)) {
                if (entity.m_20096_()) {
                    if (!flag) {
                        entity.m_146926_(0.0f);
                    }
                } else {
                    rotateBy *= 2.0f;
                    Fluid fluid = CommonPhysic.getFluid(entity);
                    if (fluid != null) {
                        rotateBy /= (float)(fluid.getAttributes().getDensity() / 1000 * 10);
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                }
            }
            if (flag) {
                pose.m_85837_(0.0, -0.2, -0.08);
            } else if (entity.f_19853_.m_8055_(entity.m_142538_()).m_60734_() == Blocks.f_50125_ || entity.f_19853_.m_8055_(entity.m_142538_().m_7495_()).m_60734_() == Blocks.f_50135_) {
                pose.m_85837_(0.0, 0.0, -0.14);
            } else {
                pose.m_85837_(0.0, 0.0, -0.04);
            }
            double height = 0.2;
            if (flag) {
                pose.m_85837_(0.0, height, 0.0);
            }
            pose.m_85845_(Vector3f.f_122225_.m_122270_(entity.m_146909_()));
            if (flag) {
                pose.m_85837_(0.0, -height, 0.0);
            }
        }
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.m_85837_((double)f7, (double)f8, (double)f9);
        }
        for (int k = 0; k < j; ++k) {
            pose.m_85836_();
            if (k > 0 && flag) {
                float f11 = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float f13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float f10 = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                pose.m_85837_((double)f11, (double)f13, (double)f10);
            }
            itemRenderer.m_115143_(itemstack, ItemTransforms.TransformType.GROUND, false, pose, buffer, packedLight, OverlayTexture.f_118083_, bakedmodel);
            pose.m_85849_();
            if (flag) continue;
            pose.m_85837_(0.0, 0.0, 0.09375);
        }
        pose.m_85849_();
        return true;
    }

    public static int getModelCount(ItemStack stack) {
        if (stack.m_41613_() > 48) {
            return 5;
        }
        if (stack.m_41613_() > 32) {
            return 4;
        }
        if (stack.m_41613_() > 16) {
            return 3;
        }
        if (stack.m_41613_() > 1) {
            return 2;
        }
        return 1;
    }

    public static boolean onPlayerInteractClient(Level level, Player player, boolean rightClick) {
        HitResult result = ItemPhysicClient.getEntityItem((Player)ItemPhysicClient.mc.f_91074_);
        if (result != null && result.m_6662_() == HitResult.Type.ENTITY) {
            ItemEntity entity = (ItemEntity)((EntityHitResult)result).m_82443_();
            if (level.f_46443_ && entity != null) {
                player.m_6674_(InteractionHand.MAIN_HAND);
                ItemPhysic.NETWORK.sendToServer((CreativePacket)new PickupPacket(entity.m_142081_(), rightClick));
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        Level world = event.getWorld();
        if ((event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteract) && world.f_46443_ && ItemPhysic.CONFIG.pickup.customPickup) {
            if (!pickup.getKey().equals((Object)InputConstants.f_84822_)) {
                return;
            }
            if (ItemPhysicClient.onPlayerInteractClient(world, event.getPlayer(), event instanceof PlayerInteractEvent.RightClickBlock) && event instanceof PlayerInteractEvent.RightClickBlock) {
                ((PlayerInteractEvent.RightClickBlock)event).setUseBlock(Event.Result.DENY);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static HitResult getEntityItem(Player player) {
        Vec3 vec3d3;
        double d2;
        AABB axisalignedbb;
        EntityHitResult entityraytraceresult;
        double distance = CommonPhysic.getReachDistance(player);
        float partialTicks = mc.m_91297_();
        Vec3 position = player.m_20299_(partialTicks);
        Vec3 vec3d1 = player.m_20252_(partialTicks);
        Vec3 look = position.m_82520_(vec3d1.f_82479_ * distance, vec3d1.f_82480_ * distance, vec3d1.f_82481_ * distance);
        BlockHitResult result = ItemPhysicClient.mc.f_91073_.m_45547_(new ClipContext(position, look, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (result != null) {
            distance = Math.min(distance, result.m_82450_().m_82557_(position));
        }
        if ((entityraytraceresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)position, (Vec3)look, (AABB)(axisalignedbb = player.m_142469_().m_82369_(vec3d1.m_82490_(distance)).m_82377_(1.0, 1.0, 1.0)), p_215312_0_ -> !p_215312_0_.m_5833_() && p_215312_0_.m_5829_(), (double)distance)) != null && ((d2 = position.m_82557_(vec3d3 = entityraytraceresult.m_82450_())) < distance || result == null)) {
            result = entityraytraceresult;
            distance = d2;
        }
        return CommonPhysic.getEntityItem(player, position, position.m_82520_(vec3d1.f_82479_ * distance, vec3d1.f_82480_ * distance, vec3d1.f_82481_ * distance), distance);
    }

    public static void renderTickFull() {
        if (mc != null && ItemPhysicClient.mc.f_91074_ != null && !mc.m_91104_()) {
            HitResult result;
            if (ItemPhysic.CONFIG.pickup.customPickup && (result = ItemPhysicClient.getEntityItem((Player)ItemPhysicClient.mc.f_91074_)) != null && result.m_6662_() == HitResult.Type.ENTITY) {
                ItemEntity entity;
                if (pickup.m_90857_()) {
                    ItemPhysicClient.onPlayerInteractClient((Level)ItemPhysicClient.mc.f_91073_, (Player)ItemPhysicClient.mc.f_91074_, false);
                }
                if ((entity = (ItemEntity)((EntityHitResult)result).m_82443_()) != null && ItemPhysic.CONFIG.rendering.showPickupTooltip) {
                    String text;
                    int i;
                    int space = 15;
                    ArrayList<Object> list = new ArrayList<Object>();
                    try {
                        entity.m_32055_().m_41720_().m_7373_(entity.m_32055_(), ItemPhysicClient.mc.f_91074_.f_19853_, list, (TooltipFlag)TooltipFlag.Default.NORMAL);
                        list.add(entity.m_32055_().m_41611_());
                    }
                    catch (Exception e) {
                        list = new ArrayList();
                        list.add(new TextComponent("ERRORED"));
                    }
                    int width = 0;
                    for (i = 0; i < list.size(); ++i) {
                        text = ((Component)list.get(i)).getString();
                        width = Math.max(width, ItemPhysicClient.mc.f_91062_.m_92895_(text) + 10);
                    }
                    RenderSystem.m_69461_();
                    RenderSystem.m_69493_();
                    for (i = 0; i < list.size(); ++i) {
                        text = ((Component)list.get(i)).getString();
                        ItemPhysicClient.mc.f_91062_.m_92750_(new PoseStack(), text, (float)(mc.m_91268_().m_85445_() / 2 - ItemPhysicClient.mc.f_91062_.m_92895_(text) / 2), (float)(mc.m_91268_().m_85446_() / 2 + (list.size() / 2 * space - space * (i + 1))), 0xFCFCFC);
                    }
                }
            }
            if (ItemPhysic.CONFIG.general.customThrow && !ItemPhysic.CONFIG.rendering.disableThrowHUD && throwingPower > 0) {
                int renderPower = throwingPower;
                if ((renderPower /= 6) < 1) {
                    renderPower = 1;
                }
                if (renderPower > 6) {
                    renderPower = 6;
                }
                ItemPhysicClient.mc.f_91074_.m_5661_((Component)new TranslatableComponent("item.throw", new Object[]{renderPower}), true);
            }
        }
    }

    @SubscribeEvent
    public static void gameTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ItemPhysicClient.mc.f_91074_ != null && ItemPhysicClient.mc.f_91074_.m_21205_() != null && ItemPhysic.CONFIG.general.customThrow) {
            if (ItemPhysicClient.mc.f_91066_.f_92094_.m_90857_()) {
                ++throwingPower;
            } else {
                if (throwingPower > 0) {
                    if ((throwingPower /= 6) < 1) {
                        throwingPower = 1;
                    }
                    if (throwingPower > 6) {
                        throwingPower = 6;
                    }
                    boolean dropAll = Screen.m_96637_();
                    ItemPhysic.NETWORK.sendToServer((CreativePacket)new DropPacket(throwingPower));
                    ServerboundPlayerActionPacket.Action cplayerdiggingpacket$action = dropAll ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
                    ItemPhysicClient.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(cplayerdiggingpacket$action, BlockPos.f_121853_, Direction.DOWN));
                    if (ItemPhysicClient.mc.f_91074_.m_150109_().m_7407_(ItemPhysicClient.mc.f_91074_.m_150109_().f_35977_, dropAll && !ItemPhysicClient.mc.f_91074_.m_150109_().m_36056_().m_41619_() ? ItemPhysicClient.mc.f_91074_.m_150109_().m_36056_().m_41613_() : 1) != ItemStack.f_41583_) {
                        ItemPhysicClient.mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                throwingPower = 0;
            }
        }
    }

    public static boolean dropItem(boolean dropAll) {
        return ItemPhysic.CONFIG.general.customThrow;
    }

    public static Vec3 getStuckSpeedMultiplier(Entity entity) {
        if (stuckSpeedMultiplierField == null) {
            stuckSpeedMultiplierField = ObfuscationReflectionHelper.findField(Entity.class, (String)"f_19865_");
        }
        try {
            return (Vec3)stuckSpeedMultiplierField.get(entity);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    static {
        skipPhysicRenderer = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"skipPhysicRenderer");
        stuckSpeedMultiplierField = null;
    }
}

