/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.itemphysic.ItemPhysicConfig;
import team.creative.itemphysic.client.ItemPhysicClient;
import team.creative.itemphysic.common.packet.DropPacket;
import team.creative.itemphysic.common.packet.PickupPacket;
import team.creative.itemphysic.server.ItemPhysicServer;

@Mod(value="itemphysic")
public class ItemPhysic {
    public static final Logger LOGGER = LogManager.getLogger((String)"itemphysic");
    public static final String MODID = "itemphysic";
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("itemphysic", "main"));
    public static ItemPhysicConfig CONFIG;

    public ItemPhysic() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        ItemPhysicClient.init(event);
        CreativeCoreClient.registerClientConfig((String)MODID);
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(DropPacket.class, DropPacket::new);
        NETWORK.registerType(PickupPacket.class, PickupPacket::new);
        CONFIG = new ItemPhysicConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        ItemPhysicServer.init(event);
    }
}

