/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.blocks.natural.FruitLeavesBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class CherryTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.cherry_log.m_49966_();
    private static final BlockState LOG_X = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
    private static final BlockState LOG_Z = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
    private static final BlockState LEAF_CANT_GROW = SkiesBlocks.cherry_leaves.m_49966_();
    private static final BlockState LEAF_CAN_GROW = (BlockState)SkiesBlocks.cherry_leaves.m_49966_().m_61124_(FruitLeavesBlock.GROWTH, (Comparable)((Object)FruitLeavesBlock.Growth.CAN_GROW));
    private static final BlockState LEAF_GROWN = (BlockState)SkiesBlocks.cherry_leaves.m_49966_().m_61124_(FruitLeavesBlock.GROWTH, (Comparable)((Object)FruitLeavesBlock.Growth.GROWN));
    private final boolean fromDungeon;

    public CherryTreeFeature(Codec<TreeConfiguration> config, boolean fromDungeonIn) {
        super(config, true);
        this.fromDungeon = fromDungeonIn;
    }

    @Override
    public boolean place(WorldGenLevel world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        if (this.fromDungeon && (!StructureAccessHelper.isInStructurePiece((ServerLevel)world.m_6018_(), (StructureFeature)SkiesStructures.NATURE_DUNGEON.getStructure(), (BlockPos)pos) || world.m_8055_(pos.m_7495_()).m_60734_() != SkiesBlocks.turquoise_cherry_grass_block)) {
            return false;
        }
        int height = rand.nextInt(3) + 10;
        if (!this.isAreaOk(world, pos, height, 1, height - 4, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        this.setLeafBall(changedLeaves, world, pos.m_142082_(0, height - 2, 0), rand);
        this.setBranches(changedLogs, changedLeaves, world, rand, pos, height);
        this.setSideLogs(changedLogs, world, pos);
        return true;
    }

    protected void setBranches(BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, Random rand, BlockPos pos, int height) {
        int i;
        int iPosX = height - 4 - rand.nextInt(3);
        int iNegX = height - 4 - rand.nextInt(3);
        int iPosZ = height - 4 - rand.nextInt(3);
        int iNegZ = height - 4 - rand.nextInt(3);
        for (i = 1; i <= 3; ++i) {
            if (i == 3) {
                this.setLeafBall(changedLeaves, world, pos.m_142082_(i, iPosX + 2, rand.nextInt(3) - 1), rand);
                this.setLeafBall(changedLeaves, world, pos.m_142082_(rand.nextInt(3) - 1, iPosZ + 2, i), rand);
            }
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(i, iPosX + i, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, iPosZ + i, i), LOG_Z);
        }
        for (i = -1; i >= -3; --i) {
            if (i == -3) {
                this.setLeafBall(changedLeaves, world, pos.m_142082_(i, iNegX + 2, rand.nextInt(3) - 1), rand);
                this.setLeafBall(changedLeaves, world, pos.m_142082_(rand.nextInt(3) - 1, iNegZ + 2, i), rand);
            }
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(i, iNegX - i, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, iNegZ - i, i), LOG_Z);
        }
    }

    protected void setLeafBall(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, BlockPos pos, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, y, z), this.getLeaf(rand));
                }
            }
        }
        this.setLeafCap(changedLeaves, world, pos.m_7495_(), rand);
        this.setLeafCap(changedLeaves, world, pos.m_6630_(3), rand);
    }

    protected void setLeafCap(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, BlockPos pos, Random rand) {
        this.setBlockIfOk(changedLeaves, world, pos, this.getLeaf(rand));
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            this.setBlockIfOk(changedLeaves, world, pos.m_142300_(dir), this.getLeaf(rand));
        }
    }

    protected void setSideLogs(BiConsumer<BlockPos, BlockState> changedLogs, WorldGenLevel world, BlockPos pos) {
        for (int i = 0; i >= -1; --i) {
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(1, i, 0), LOG);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(-1, i, 0), LOG);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, i, 1), LOG);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, i, -1), LOG);
        }
    }

    protected BlockState getLeaf(Random rand) {
        if ((double)rand.nextFloat() < 0.3) {
            return rand.nextBoolean() ? LEAF_CAN_GROW : LEAF_GROWN;
        }
        return LEAF_CANT_GROW;
    }

    @Override
    public TagKey<ConfiguredStructureFeature<?, ?>> disallowedStructures() {
        return this.fromDungeon ? null : super.disallowedStructures();
    }
}

