/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class DuskTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.dusk_log.m_49966_();
    private static final BlockState LOG_X = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
    private static final BlockState LOG_Z = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.m_49966_();
    protected int minTreeHeight;

    public DuskTreeFeature(Codec<TreeConfiguration> config, int minTreeHeightIn) {
        super(config, true);
        this.minTreeHeight = minTreeHeightIn;
    }

    @Override
    public boolean place(WorldGenLevel world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int height = rand.nextInt(3) + this.minTreeHeight;
        if (!this.isAreaOk(world, pos, height, 1, height - 3, 7)) {
            return false;
        }
        this.setLeafCanopy(changedLeaves, world, rand, pos.m_142082_(0, height - 2, 0));
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        this.setBranches(changedLogs, world, rand, pos, height);
        return true;
    }

    protected void setBranches(BiConsumer<BlockPos, BlockState> changedLogs, WorldGenLevel world, Random rand, BlockPos pos, int height) {
        int y = height - 3;
        if (rand.nextBoolean()) {
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(1, y, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(-1, y, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(2, y + 1, 0), LOG);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(-2, y + 1, 0), LOG);
        } else {
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, y, 1), LOG_Z);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, y, -1), LOG_Z);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, y + 1, 2), LOG);
            this.setBlockIfOk(changedLogs, world, pos.m_142082_(0, y + 1, -2), LOG);
        }
    }

    protected void setLeafCanopy(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, Random rand, BlockPos pos) {
        int z;
        int x;
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3 || rand.nextInt(3) != 0) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, 0, z), LEAF);
            }
        }
        pos = pos.m_7494_();
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, 0, z), LEAF);
            }
        }
        for (int longSide = -4; longSide <= 4; ++longSide) {
            for (int shortSide = -1; shortSide <= 1; ++shortSide) {
                if (Math.abs(longSide) != 4) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_142082_(longSide, 0, shortSide), LEAF);
                this.setBlockIfOk(changedLeaves, world, pos.m_142082_(shortSide, 0, longSide), LEAF);
            }
        }
        pos = pos.m_7494_();
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_142082_(x, 0, z), LEAF);
            }
        }
    }
}

