/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OceanSpikeFeature
extends Feature<NoneFeatureConfiguration>
implements IStructureRestricted {
    private static final BlockState SAND = SkiesBlocks.midnight_sand.m_49966_();
    private static final BlockState SANDSTONE = SkiesBlocks.midnight_sandstone.m_49966_();

    public OceanSpikeFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        if (!this.shouldGenerate(level, pos = level.m_5452_(Heightmap.Types.OCEAN_FLOOR, pos))) {
            return false;
        }
        Random rand = level.m_5822_();
        if (pos.m_123342_() > level.m_5736_()) {
            return false;
        }
        if (rand.nextBoolean()) {
            int centerHeight = rand.nextInt(2) + 7;
            if (pos.m_123342_() + centerHeight < level.m_5736_() - 1) {
                for (int y = 0; y < centerHeight; ++y) {
                    int i;
                    this.setBlock((LevelAccessor)level, pos.m_6630_(y), y == centerHeight - 1);
                    for (i = -1; i <= 1 && (y < 4 || y < 5 && rand.nextBoolean()); i += 2) {
                        this.setBlock((LevelAccessor)level, pos.m_142082_(i, y, 0), y >= 3);
                        this.setBlock((LevelAccessor)level, pos.m_142082_(0, y, i), y >= 3);
                    }
                    for (i = -1; i <= 1 && (y < 2 || y < 3 && rand.nextBoolean()); i += 2) {
                        this.setBlock((LevelAccessor)level, pos.m_142082_(i, y, i), y >= 2);
                        this.setBlock((LevelAccessor)level, pos.m_142082_(-i, y, i), y >= 2);
                    }
                    for (i = -2; i <= 2 && y < 1; i += 4) {
                        this.setBlock((LevelAccessor)level, pos.m_142082_(i, y, 0), true);
                        this.setBlock((LevelAccessor)level, pos.m_142082_(0, y, i), true);
                    }
                }
                int maxXZ = 2;
                for (int x = -maxXZ; x <= maxXZ; ++x) {
                    for (int z = -maxXZ; z <= maxXZ; ++z) {
                        for (int y = -1; y >= -2; --y) {
                            if (Math.abs(x) == maxXZ && Math.abs(x) == Math.abs(z)) continue;
                            this.setBlock((LevelAccessor)level, pos.m_142082_(x, y, z), true);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        if (rand.nextBoolean()) {
            int y;
            for (y = 0; y <= 2; ++y) {
                this.setBlock((LevelAccessor)level, pos.m_6630_(y), y >= 2);
            }
            for (y = 0; y >= -2; --y) {
                for (int xz = -1; xz <= 1; xz += 2) {
                    this.setBlock((LevelAccessor)level, pos.m_142082_(xz, y, 0), false);
                    this.setBlock((LevelAccessor)level, pos.m_142082_(0, y, xz), false);
                }
            }
            boolean x = rand.nextBoolean();
            boolean positive = rand.nextBoolean();
            this.setBlock((LevelAccessor)level, pos.m_142082_(x ? 1 * (positive ? 1 : -1) : 0, 1, x ? 0 : 1 * (positive ? 1 : -1)), true);
            return true;
        }
        return false;
    }

    private void setBlock(LevelAccessor world, BlockPos pos, boolean sand) {
        world.m_7731_(pos, sand ? SAND : SANDSTONE, 2);
    }
}

