/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.entities.util.damage_source.SummonedDamageSource;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityUtil {
    public static final Predicate<Entity> CAN_ATTACK = EntitySelector.f_20406_.and(EntitySelector.f_20403_);

    public static float getDistanceToPos(Vec3i startingPos, Vec3i farPos) {
        return (float)GeometryHelper.calcDistance(Vec3.m_82512_((Vec3i)startingPos), Vec3.m_82512_((Vec3i)farPos));
    }

    public static BlockPos getPosWithHeightmap(BlockPos pos, Heightmap.Types heightType, Level world) {
        return new BlockPos(pos.m_123341_(), world.m_6924_(heightType, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
    }

    public static boolean isPosInStructure(Level world, BlockPos pos, StructureFeature<?> structure) {
        ServerLevel sl;
        return world instanceof ServerLevel && StructureAccessHelper.isInStructurePiece((ServerLevel)(sl = (ServerLevel)world), structure, (BlockPos)pos);
    }

    public static boolean canSpawnWithoutFlooding(LivingEntity entityIn) {
        List list = entityIn.f_19853_.m_6443_(entityIn.getClass(), entityIn.m_142469_().m_82400_(10.0), EntitySelector.f_20403_);
        return list.size() < 2;
    }

    public static boolean isInDungeon(Level world, BlockPos pos) {
        for (StructureFeature<?> dungeon : SkiesStructures.dungeons) {
            if (!EntityUtil.isPosInStructure(world, pos, dungeon)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playMovingSound(SoundEvent soundIn, LivingEntity entityIn, float volumeIn, float pitchIn) {
        SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
        soundHandler.m_120367_((SoundInstance)new MovingEntitySound(entityIn, soundIn, volumeIn, pitchIn, false));
    }

    public static boolean hasPlayerProgressedTo(Player player, boolean bright, int progressionId) {
        return SkiesPlayer.getIfPresent(player, skyPlayer -> bright ? skyPlayer.getBrightProgression() >= progressionId : skyPlayer.getDawnProgression() >= progressionId, () -> false);
    }

    public static boolean hasPlayerCompletedProgression(Player player) {
        return SkiesPlayer.getIfPresent(player, EntityUtil::hasPlayerCompletedProgression, () -> false);
    }

    public static boolean hasPlayerCompletedProgression(ISkiesPlayer skyPlayer) {
        byte maxProgression = 3;
        return skyPlayer.getBrightProgression() >= maxProgression && skyPlayer.getDawnProgression() >= maxProgression || skyPlayer.getPlayer().m_7500_();
    }

    public static boolean isVillagerWorkTime(Villager villager) {
        return villager.m_6274_() != null && villager.m_6274_().m_21932_().m_38019_((int)(villager.f_19853_.m_46468_() % 24000L)) == Activity.f_37980_;
    }

    public static float getSoundPitchWithStart(Random rand, float basePitch) {
        return EntityUtil.getSoundPitchWithStart(rand, basePitch, 0.2f);
    }

    public static float getSoundPitchWithStart(Random rand, float basePitch, float range) {
        return (rand.nextFloat() - rand.nextFloat()) * range + basePitch;
    }

    public static ItemStack makeFirework(DyeColor color, int flightTime, DyeColor fadeColor) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, 1);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundnbt = itemstack1.m_41698_("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(color.m_41070_());
        compoundnbt.m_128408_("Colors", (List)list);
        ArrayList fadelist = Lists.newArrayList();
        fadelist.add(fadeColor.m_41070_());
        compoundnbt.m_128408_("FadeColors", (List)fadelist);
        compoundnbt.m_128344_("Type", (byte)FireworkRocketItem.Shape.LARGE_BALL.m_41236_());
        CompoundTag compoundnbt1 = itemstack.m_41698_("Fireworks");
        ListTag listnbt = new ListTag();
        compoundnbt.m_128379_("Flicker", true);
        CompoundTag compoundnbt2 = itemstack1.m_41737_("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.m_128344_("Flight", (byte)flightTime);
        if (!listnbt.isEmpty()) {
            compoundnbt1.m_128365_("Explosions", (Tag)listnbt);
        }
        return itemstack;
    }

    public static boolean hasAdvancement(ServerPlayer player, ResourceLocation advancement) {
        if (player != null && player.m_20194_() != null && player.m_20194_().m_129889_().m_136041_(advancement) != null) {
            return player.m_8960_().m_135996_(player.m_20194_().m_129889_().m_136041_(advancement)).m_8193_();
        }
        return false;
    }

    public static void sendJournalToast(Player player) {
        if (player instanceof ServerPlayer) {
            PacketHandler.sendToClient(new DisplayToastPacket(0), (ServerPlayer)player);
        }
    }

    public static boolean canEntitySeePos(LivingEntity entity, BlockPos posToLookAt) {
        if (entity != null) {
            Vec3 vec3d = entity.m_20252_(1.0f).m_82541_();
            Vec3 vec3d1 = new Vec3((double)posToLookAt.m_123341_() - entity.m_20185_(), (double)posToLookAt.m_123342_() - (entity.m_20186_() + (double)entity.m_20192_()), (double)posToLookAt.m_123343_() - entity.m_20189_());
            double d0 = vec3d1.m_82553_();
            double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
            return !(d1 < 1.0 / d0);
        }
        return false;
    }

    public static BlockPos getPosInFront(LivingEntity entity, double distance) {
        return new BlockPos(entity.m_20185_() - (double)(entity.m_20205_() + 1.0f) * distance * (double)Mth.m_14031_((float)(entity.f_20883_ * ((float)Math.PI / 180))), entity.m_20188_() - (double)0.1f, entity.m_20189_() + (double)(entity.m_20205_() + 1.0f) * distance * (double)Mth.m_14089_((float)(entity.f_20883_ * ((float)Math.PI / 180))));
    }

    public static List<BlockPos> createSquareOffsetsFromPos(BlockPos pos, double offset) {
        ArrayList positions = Lists.newArrayList();
        positions.add(pos.m_142022_(offset, 0.0, offset));
        positions.add(pos.m_142022_(offset, 0.0, -offset));
        positions.add(pos.m_142022_(-offset, 0.0, -offset));
        positions.add(pos.m_142022_(-offset, 0.0, offset));
        return positions;
    }

    public static List<BlockPos> createDiamondOffsetsFromPos(BlockPos pos, int offset) {
        ArrayList positions = Lists.newArrayList();
        positions.add(pos.m_5484_(Direction.NORTH, offset));
        positions.add(pos.m_5484_(Direction.EAST, offset));
        positions.add(pos.m_5484_(Direction.SOUTH, offset));
        positions.add(pos.m_5484_(Direction.WEST, offset));
        return positions;
    }

    public static boolean hasNoCollisionsInPath(LivingEntity entity, BlockPos pos) {
        Vec3 movementPos = new Vec3((double)pos.m_123341_() - entity.m_20185_(), (double)pos.m_123342_() - entity.m_20186_(), (double)pos.m_123343_() - entity.m_20189_());
        double vecLength = movementPos.m_82553_();
        movementPos = movementPos.m_82541_();
        AABB axisalignedbb = entity.m_142469_();
        for (int i = 1; i < Mth.m_14165_((double)vecLength); ++i) {
            if (entity.f_19853_.m_45756_((Entity)entity, axisalignedbb = axisalignedbb.m_82369_(movementPos))) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getClosestPosInList(BlockPos startingPos, List<BlockPos> list) {
        BlockPos closest = null;
        for (BlockPos outsidePos : list) {
            double oldDist;
            if (closest == null) {
                closest = outsidePos.m_7949_();
                continue;
            }
            double newDist = EntityUtil.getDistanceToPos((Vec3i)outsidePos, (Vec3i)startingPos);
            if (!(newDist < (oldDist = (double)EntityUtil.getDistanceToPos((Vec3i)closest, (Vec3i)startingPos)))) continue;
            closest = outsidePos.m_7949_();
        }
        return closest;
    }

    public static int getIndexOfClosestPos(BlockPos startingPos, List<BlockPos> list) {
        BlockPos closest = null;
        int closestIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            double oldDist;
            BlockPos outsidePos = list.get(i);
            if (closest == null) {
                closest = outsidePos.m_7949_();
                continue;
            }
            double newDist = EntityUtil.getDistanceToPos((Vec3i)outsidePos, (Vec3i)startingPos);
            if (!(newDist < (oldDist = (double)EntityUtil.getDistanceToPos((Vec3i)closest, (Vec3i)startingPos)))) continue;
            closestIndex = i;
            closest = outsidePos.m_7949_();
        }
        return closestIndex;
    }

    public static void attachToEntity(float segmentSeparation, LivingEntity follower, LivingEntity parent) {
        if (follower instanceof Mob) {
            Mob mobFollower = (Mob)follower;
            mobFollower.m_146922_(mobFollower.f_20885_);
            mobFollower.m_21563_().m_24960_((Entity)parent, 180.0f, 180.0f);
        }
        Vec3 difference = new Vec3(follower.m_20185_() - parent.m_20185_(), follower.m_20186_() - parent.m_20186_(), follower.m_20189_() - parent.m_20189_()).m_82541_();
        follower.m_6034_((double)segmentSeparation * difference.m_7096_() + parent.m_20185_(), (double)segmentSeparation * difference.m_7098_() + parent.m_20186_(), (double)segmentSeparation * difference.m_7094_() + parent.m_20189_());
    }

    public static Stream<PoiRecord> getPoisInCircle(Entity entity, PoiType type, int radius) {
        if (!(entity.f_19853_ instanceof ServerLevel)) {
            return Stream.empty();
        }
        BlockPos startPos = entity.m_142538_();
        ServerLevel world = (ServerLevel)entity.f_19853_;
        PoiManager pointofinterestmanager = world.m_8904_();
        pointofinterestmanager.m_27056_((LevelReader)entity.f_19853_, startPos, radius);
        Stream stream = world.m_8904_().m_27181_(poiType -> poiType == type, startPos, radius, PoiManager.Occupancy.ANY);
        return stream;
    }

    public static class DamageSources {
        public static final DamageSource DEADLY_VENOM = new DamageSource(BlueSkies.find("venom_spit")).m_19380_().m_19389_();
        public static final DamageSource SPIKE = new DamageSource(BlueSkies.find("rock_stab")).m_19380_().m_19366_();
        public static final DamageSource ROOT = new DamageSource(BlueSkies.find("root"));

        public static DamageSource causeSummonDamage(Entity directEntityIn, LivingEntity summonerEntityIn) {
            return new SummonedDamageSource(BlueSkies.find("summon"), directEntityIn, (Entity)summonerEntityIn);
        }

        public static DamageSource causeEmberDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("ember"), directEntityIn).m_19383_();
        }

        public static DamageSource causeBiteDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("bite"), directEntityIn);
        }

        public static DamageSource causeIndirectSpikeDamage(Entity entityIn) {
            return new EntityDamageSource(BlueSkies.find("rock_stab.mob"), entityIn).m_19380_().m_19366_();
        }

        public static DamageSource causeStrangeLightningDamage(Entity ownerIn) {
            return new EntityDamageSource(BlueSkies.find("summoned_lightning"), ownerIn).m_19380_().m_19366_();
        }

        public static DamageSource causeShockDamage(Entity shooterIn) {
            return new EntityDamageSource(BlueSkies.find("fluctuant_sphere"), shooterIn).m_19389_().m_19366_();
        }

        public static DamageSource causeIndirectVenomDamage(Entity projectileIn, Entity shooterIn) {
            return new IndirectEntityDamageSource(BlueSkies.find("venom_spit.mob"), projectileIn, shooterIn).m_19366_();
        }

        public static DamageSource causeSlamDamage(Entity directEntityIn) {
            return new EntityDamageSource(BlueSkies.find("slam"), directEntityIn).m_19380_();
        }

        public static DamageSource causeNeedleDamage(Entity shooterIn) {
            return new EntityDamageSource(BlueSkies.find("needle"), shooterIn).m_19366_().m_19380_();
        }
    }
}

