/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructureProcessors;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerPools;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.FrozenBunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHousePools;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseStructure;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillagePools;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageStructure;
import com.legacy.blue_skies.world.util.structure_processors.RemoveSnowStructureProcessor;
import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesStructures {
    public static final StructureRegistrar<JigsawConfiguration, FrozenBunkerStructure> FROZEN_BUNKER = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("frozen_bunker"), () -> new FrozenBunkerStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_)).addPiece(FrozenBunkerStructure.Piece::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(FrozenBunkerPools.ROOT, 7)).biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SLUSHLANDS.getBiome()})}).popConfigured().build();
    public static final StructureRegistrar<NoneFeatureConfiguration, EverbrightBlindingDungeonStructure> EVERBRIGHT_BLINDING_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("everbright_blinding_dungeon"), () -> new EverbrightBlindingDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_)).addPiece(EverbrightBlindingDungeonPieces.Piece::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.CALMING_SKIES.getBiome(), SkiesBiomes.BRISK_MEADOW.getBiome(), SkiesBiomes.BRIGHTLANDS.getBiome(), SkiesBiomes.SNOW_COVERED_PINES.getBiome()})}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, new MobSpawnSettings.SpawnerData[0]).popConfigured().build();
    public static final StructureRegistrar<NoneFeatureConfiguration, EverdawnBlindingDungeonStructure> EVERDAWN_BLINDING_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("everdawn_blinding_dungeon"), () -> new EverdawnBlindingDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_)).addPiece(EverdawnBlindingDungeonPieces.Piece::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SHADED_WOODLANDS.getBiome(), SkiesBiomes.CRYSTAL_DUNES.getBiome(), SkiesBiomes.SUNSET_MAPLE_FOREST.getBiome(), SkiesBiomes.CRESCENT_ORCHARD.getBiome(), SkiesBiomes.CRYSTAL_ROUGHS.getBiome(), SkiesBiomes.SEARING_GRASSLAND.getBiome()})}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, new MobSpawnSettings.SpawnerData[0]).popConfigured().build();
    public static final StructureRegistrar<NoneFeatureConfiguration, NatureDungeonStructure> NATURE_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("nature_dungeon"), () -> new NatureDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_)).addPiece("main", NatureDungeonPieces.Piece::new).addPiece("garden", NatureDungeonPieces.GardenPiece::new).addPiece("stone_fill", NatureDungeonPieces.StoneFillPiece::new).addPiece("air_bubble", NatureDungeonPieces.AirBubblePiece::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SNOW_COVERED_PINES.getBiome()})}).spawns(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, NatureDungeonStructure.DUNGEON_ENEMIES)).popConfigured().build();
    public static final StructureRegistrar<NoneFeatureConfiguration, PoisonDungeonStructure> POISON_DUNGEON = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("poison_dungeon"), () -> new PoisonDungeonStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_)).addPiece(PoisonDungeonPieces.Piece::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67737_).biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SUNSET_MAPLE_FOREST.getBiome()})}).spawns(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, PoisonDungeonStructure.DUNGEON_ENEMIES)).popConfigured().build();
    public static final StructureRegistrar<JigsawConfiguration, GatekeeperHouseStructure> GATEKEEPER_HOUSE = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("gatekeeper_house"), () -> new GatekeeperHouseStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_)).addPiece(GatekeeperHouseStructure.Piece::new).pushConfigured("plains", (FeatureConfiguration)new JigsawConfiguration(GatekeeperHousePools.PLAINS, 7)).adaptNoise().biomes(new HolderSet[]{BiomeDictionary.PLAINS, BiomeDictionary.SAVANNA}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, new MobSpawnSettings.SpawnerData[0]).popConfigured().pushConfigured("snowy", (FeatureConfiguration)new JigsawConfiguration(GatekeeperHousePools.SNOWY, 7)).adaptNoise().biomes(new HolderSet[]{BiomeDictionary.SNOWY, BiomeDictionary.SNOWY_SPRUCE_FOREST, BiomeDictionary.SPRUCE_FOREST}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, new MobSpawnSettings.SpawnerData[0]).popConfigured().pushConfigured("mountain", (FeatureConfiguration)new JigsawConfiguration(GatekeeperHousePools.MOUNTAIN, 7)).adaptNoise().biomes(new HolderSet[]{BiomeDictionary.MOUNTAIN}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.PIECE, new MobSpawnSettings.SpawnerData[0]).popConfigured().build();
    public static final StructureRegistrar<JigsawConfiguration, SkiesVillageStructure> BLUE_SKIES_VILLAGE = StructureRegistrar.builder((ResourceLocation)BlueSkies.locate("village"), () -> new SkiesVillageStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_)).addPiece(SkiesVillageStructure.Piece::new).pushConfigured(SkiesVillageBiomes.CALMING_SKIES.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.CALMING_SKIES, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.CALMING_SKIES.getBiome()})}).popConfigured().pushConfigured(SkiesVillageBiomes.BRIGHTLANDS.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.BRIGHTLANDS, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SNOW_COVERED_PINES.getBiome()})}).popConfigured().pushConfigured(SkiesVillageBiomes.SLUSHLANDS.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.SLUSHLANDS, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SLUSHLANDS.getBiome()})}).popConfigured().pushConfigured(SkiesVillageBiomes.SHADED_WOODLANDS.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.SHADED_WOODLANDS, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SHADED_WOODLANDS.getBiome()})}).popConfigured().pushConfigured(SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.SUNSET_MAPLE_FOREST, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.SUNSET_MAPLE_FOREST.getBiome()})}).popConfigured().pushConfigured(SkiesVillageBiomes.CRYSTAL_DUNES.toString(), (FeatureConfiguration)new JigsawConfiguration(SkiesVillagePools.CRYSTAL_DUNES, 6)).adaptNoise().biomes(new HolderSet[]{HolderSet.m_205809_((Holder[])new Holder[]{SkiesBiomes.CRYSTAL_DUNES.getBiome()})}).popConfigured().build();
    public static StructureFeature<?>[] dungeons = new StructureFeature[0];

    public static void init(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesStructureProcessors.init();
        Processors.init();
        FrozenBunkerPools.init();
        FROZEN_BUNKER.handleForge(registry);
        EVERBRIGHT_BLINDING_DUNGEON.handleForge(registry);
        EVERDAWN_BLINDING_DUNGEON.handleForge(registry);
        NATURE_DUNGEON.handleForge(registry);
        POISON_DUNGEON.handleForge(registry);
        GatekeeperHousePools.init();
        GATEKEEPER_HOUSE.handleForge(registry);
        SkiesVillagePools.init();
        BLUE_SKIES_VILLAGE.handleForge(registry);
        dungeons = new StructureFeature[]{EVERBRIGHT_BLINDING_DUNGEON.getStructure(), EVERDAWN_BLINDING_DUNGEON.getStructure(), NATURE_DUNGEON.getStructure(), POISON_DUNGEON.getStructure()};
    }

    public static class Processors {
        public static final Holder<StructureProcessorList> DECAY_TURQUOISE_STONEBRICK = Processors.register("decay_turquoise_stonebrick", new StructureProcessorList(List.of(new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.1f, SkiesBlocks.mossy_turquoise_stonebrick), new RandomBlockSwapProcessor(SkiesBlocks.turquoise_stonebrick, 0.2f, SkiesBlocks.cracked_turquoise_stonebrick))));
        public static final Holder<StructureProcessorList> REMOVE_SNOW = Processors.register("remove_snow", RemoveSnowStructureProcessor.INSTANCE);
        public static final Holder<StructureProcessorList> SWAP_PORTAL = Processors.register("swap_portal", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stonebrick, SkiesBlocks.turquoise_stonebrick));
        public static final Holder<StructureProcessorList> MODIFY_GRASS = Processors.register("modify_grass", (StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50069_), Blocks.f_50069_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49994_), Blocks.f_50069_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_50016_), Blocks.f_50069_.m_49966_()))));
        public static final Holder<StructureProcessorList> MODIFY_PATH = Processors.register("modify_path", (StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_152481_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_152481_, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50440_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50440_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()), new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50493_), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_50705_.m_49966_()))));
        public static final Holder<StructureProcessorList> SWAP_PORTAL_MODIFY_GRASS = Processors.register("swap_portal_modify_grass", RegistryHelper.combineProcessors((Holder[])new Holder[]{SWAP_PORTAL, MODIFY_GRASS}));
        public static final Holder<StructureProcessorList> SWAP_PORTAL_REMOVE_SNOW = Processors.register("swap_portal_remove_snow", RegistryHelper.combineProcessors((Holder[])new Holder[]{SWAP_PORTAL, REMOVE_SNOW}));
        public static final Holder<StructureProcessorList> CALMING_SKIES_STREET = Processors.register("calming_skies_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.bluebright_planks, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone));
        public static final Holder<StructureProcessorList> BRIGHTLANDS_STREET = Processors.register("brightlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.turquoise_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.starlit_planks, SkiesBlocks.midnight_sand, SkiesBlocks.midnight_sandstone));
        public static final Holder<StructureProcessorList> SLUSHLANDS_STREET = Processors.register("slushlands_street", (StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.frostbright_planks, 0.2f, SkiesBlocks.stripped_frostbright_wood));
        public static final Holder<StructureProcessorList> SHADED_WOODLANDS_STREET = Processors.register("shaded_woodlands_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_planks, SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone));
        public static final Holder<StructureProcessorList> SUNSET_MAPLE_FOREST_STREET = Processors.register("sunset_maple_forest_street", (StructureProcessor)Processors.makeVillagePath(SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.lunar_grass_block, SkiesBlocks.maple_planks, SkiesBlocks.crystal_sand, SkiesBlocks.crystal_sandstone));
        public static final Holder<StructureProcessorList> CRYSTAL_DUNES = Processors.register("crystal_dunes_street", new StructureProcessorList(List.of()));

        public static void init() {
        }

        private static Holder<StructureProcessorList> register(String key, StructureProcessor processor) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessor)processor);
        }

        private static Holder<StructureProcessorList> register(String key, StructureProcessorList processorList) {
            return RegistryHelper.registerProcessor((ResourceLocation)BlueSkies.locate(key), (StructureProcessorList)processorList);
        }

        private static RuleProcessor makeVillagePath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial, @Nullable Block sand, @Nullable Block sandstone) {
            return new RuleProcessor(Processors.standardPath(path, dirt, grassBlock, bridgeMaterial, sand, sandstone));
        }

        private static List<ProcessorRule> standardPath(Block path, Block dirt, Block grassBlock, Block bridgeMaterial, @Nullable Block sand, @Nullable Block sandstone) {
            ArrayList<ProcessorRule> rules = new ArrayList<ProcessorRule>();
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_()));
            if (sand != null && sandstone != null) {
                rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(sand), sandstone.m_49966_()));
            }
            rules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest(path, 0.2f), (RuleTest)AlwaysTrueTest.f_73954_, grassBlock.m_49966_()));
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(grassBlock), (RuleTest)new BlockMatchTest(Blocks.f_49990_), Blocks.f_49990_.m_49966_()));
            rules.add(new ProcessorRule((RuleTest)new BlockMatchTest(dirt), (RuleTest)new BlockMatchTest(Blocks.f_49990_), bridgeMaterial.m_49966_()));
            return rules;
        }
    }
}

