/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeSource;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeSource;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.events.RegisterBiomeDictionaryTypeEvent;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;

public class SkiesBiomeDict {
    @Nullable
    private static LinkedList<BiomeType> types = new LinkedList();
    public static final BiomeType EVERBRIGHT_DEEP_OCEAN = SkiesBiomeDict.register(SkiesBiomeDict.builder("everbright_deep_ocean").biomes(new BiomeRegistrar[]{SkiesBiomes.DEEP_PEEKING_OCEAN, SkiesBiomes.BRUMBLE_FOREST}));
    public static final BiomeType EVERBRIGHT_OCEAN = SkiesBiomeDict.register(SkiesBiomeDict.builder("everbright_ocean").biomes(new BiomeRegistrar[]{SkiesBiomes.PEEKING_OCEAN}).parents(new BiomeType[]{EVERBRIGHT_DEEP_OCEAN}));
    public static final BiomeType BRIGHTLANDS = SkiesBiomeDict.register(SkiesBiomeDict.builder("brightlands").biomes(new BiomeRegistrar[]{SkiesBiomes.BRIGHTLANDS}));
    public static final BiomeType SNOW_COVERED_PINES = SkiesBiomeDict.register(SkiesBiomeDict.builder("snow_covered_pines").biomes(new BiomeRegistrar[]{SkiesBiomes.SNOW_COVERED_PINES}));
    public static final BiomeType CALMING_SKIES = SkiesBiomeDict.register(SkiesBiomeDict.builder("calming_skies").biomes(new BiomeRegistrar[]{SkiesBiomes.CALMING_SKIES}));
    public static final BiomeType POLAR_HIGHLAND = SkiesBiomeDict.register(SkiesBiomeDict.builder("polar_highland").biomes(new BiomeRegistrar[]{SkiesBiomes.POLAR_HIGHLAND}));
    public static final BiomeType BRISK_MEADOW = SkiesBiomeDict.register(SkiesBiomeDict.builder("brisk_meadow").biomes(new BiomeRegistrar[]{SkiesBiomes.BRISK_MEADOW}));
    public static final BiomeType SLUSHLANDS = SkiesBiomeDict.register(SkiesBiomeDict.builder("slushlands").biomes(new BiomeRegistrar[]{SkiesBiomes.SLUSHLANDS}));
    public static final BiomeType FROSTBITTEN_FOREST = SkiesBiomeDict.register(SkiesBiomeDict.builder("frostbitten_forest").biomes(new BiomeRegistrar[]{SkiesBiomes.FROSTBITTEN_FOREST, SkiesBiomes.FROSTBITTEN_FOREST_CLEARING}));
    public static final BiomeType EVERBRIGHT_SNOWY = SkiesBiomeDict.register(SkiesBiomeDict.builder("everbright_snowy").parents(new BiomeType[]{BRIGHTLANDS, SNOW_COVERED_PINES, FROSTBITTEN_FOREST}));
    public static final BiomeType EVERDAWN_RIVER = SkiesBiomeDict.register(SkiesBiomeDict.builder("everdawn_river").biomes(new BiomeRegistrar[]{SkiesBiomes.RISING_CREEK}));
    public static final BiomeType CRYSTAL_DUNES = SkiesBiomeDict.register(SkiesBiomeDict.builder("crystal_dunes").biomes(new BiomeRegistrar[]{SkiesBiomes.CRYSTAL_DUNES, SkiesBiomes.CRYSTAL_DUNES_SPIKES}));
    public static final BiomeType CRYSTAL_ROUGHS = SkiesBiomeDict.register(SkiesBiomeDict.builder("crystal_roughs").biomes(new BiomeRegistrar[]{SkiesBiomes.CRYSTAL_ROUGHS}));
    public static final BiomeType SHADED_WOODLANDS = SkiesBiomeDict.register(SkiesBiomeDict.builder("shaded_woodlands").biomes(new BiomeRegistrar[]{SkiesBiomes.SHADED_WOODLANDS}));
    public static final BiomeType UNORTHODOX_VALLEY = SkiesBiomeDict.register(SkiesBiomeDict.builder("unorthodox_valley").biomes(new BiomeRegistrar[]{SkiesBiomes.UNORTHODOX_VALLEY}));
    public static final BiomeType SUNSET_MAPLE_FOREST = SkiesBiomeDict.register(SkiesBiomeDict.builder("sunset_maple_forest").biomes(new BiomeRegistrar[]{SkiesBiomes.SUNSET_MAPLE_FOREST}));
    public static final BiomeType SEARING_GRASSLAND = SkiesBiomeDict.register(SkiesBiomeDict.builder("searing_grassland").biomes(new BiomeRegistrar[]{SkiesBiomes.SEARING_GRASSLAND}));
    public static final BiomeType CRESCENT_ORCHARD = SkiesBiomeDict.register(SkiesBiomeDict.builder("crescent_orchard").biomes(new BiomeRegistrar[]{SkiesBiomes.CRESCENT_ORCHARD, SkiesBiomes.CRESCENT_ORCHARD_LAKE}));
    public static final BiomeType MOONLIT_RESERVOIR = SkiesBiomeDict.register(SkiesBiomeDict.builder("moonlit_reservoir").biomes(new BiomeRegistrar[]{SkiesBiomes.MOONLIT_RESERVOIR}));
    public static final BiomeType EVERBRIGHT = SkiesBiomeDict.register(SkiesBiomeDict.builder("everbright").biomes(new BiomeSource[]{new EverbrightBiomeSource((Registry<Biome>)BuiltinRegistries.f_123865_, 0L, 0, 256)}));
    public static final BiomeType EVERDAWN = SkiesBiomeDict.register(SkiesBiomeDict.builder("everdawn").biomes(new BiomeSource[]{new EverdawnBiomeSource((Registry<Biome>)BuiltinRegistries.f_123865_, 0L, 0, 256)}));

    public static void init(RegisterBiomeDictionaryTypeEvent event) {
        types.forEach(arg_0 -> ((RegisterBiomeDictionaryTypeEvent)event).register(arg_0));
        types = null;
    }

    private static BiomeType.Builder builder(String key) {
        return BiomeType.builder((ResourceLocation)BlueSkies.locate(key));
    }

    private static BiomeType register(BiomeType.Builder type) {
        BiomeType built = type.build();
        types.add(built);
        return built;
    }
}

