/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class SkiesVillagerTrades {
    private static final List<Item> EVERBRIGHT_STICKS = Lists.newArrayList((Object[])new Item[]{SkiesItems.bluebright_stick, SkiesItems.starlit_stick, SkiesItems.frostbright_stick, SkiesItems.cherry_stick});
    private static final List<Item> EVERDAWN_STICKS = Lists.newArrayList((Object[])new Item[]{SkiesItems.lunar_stick, SkiesItems.dusk_stick, SkiesItems.maple_stick, SkiesItems.cherry_stick});
    private static final Item EMERALD = Items.f_42616_;
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> STARGAZER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.falsite_ingot, 4).secondItem((ItemLike)SkiesItems.moonstone_shard, 1).result((ItemLike)Items.f_42524_, 1).build(), new SingleTrade.Builder().item((ItemLike)SkiesBlocks.star_flare, 32).result((ItemLike)EMERALD, 1).maxUses(10).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.ventium_ingot, 4).secondItem((ItemLike)SkiesItems.moonstone_shard, 1).result((ItemLike)Items.f_42522_, 1).givenXP(10).build(), new SingleTrade.Builder().item((ItemLike)Blocks.f_50058_, 16).result((ItemLike)EMERALD, 1).maxUses(10).givenXP(7).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)Items.f_42416_, 5).result((ItemLike)EMERALD, 1).givenXP(15).build(), new EmeraldForMapTrade("frozen_bunker", 7, SkiesStructureTags.ON_BUNKER_MAPS, MapDecoration.Type.TARGET_POINT, 12, 20)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesBlocks.moonstone, 6).secondItem((ItemLike)Blocks.f_50183_, 8).result((ItemLike)SkiesBlocks.moonstone_lantern, 3).maxUses(15).givenXP(25).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 10).result((ItemLike)SkiesItems.astrolabe, 1).givenXP(30).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> WRANGLER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.cooked_charscale_moki, 4).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42655_, 4).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)EMERALD, 1).secondItem((ItemLike)Items.f_42454_, 4).result((ItemLike)Items.f_42450_, 1).maxUses(15).givenXP(10).build(), new SingleTrade.Builder().item((ItemLike)SkiesItems.azulfo_horn, 16).result((ItemLike)EMERALD, 1).maxUses(10).givenXP(7).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.cooked_monitor_tail, 3).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 2).result((ItemLike)SkiesItems.cooked_grittle_flatfish, 6).maxUses(10).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 2).result((ItemLike)Items.f_42659_, 8).maxUses(10).givenXP(13).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.cherry, 6).secondItem((ItemLike)EMERALD, 1).result((ItemLike)SkiesBlocks.cherry_pie, 1).givenXP(20).build(), new SingleTrade.Builder().item((ItemLike)Items.f_42401_, 26).result((ItemLike)EMERALD, 1).maxUses(10).givenXP(16).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 2).result((ItemLike)SkiesItems.cooked_carabeef, 4).maxUses(10).givenXP(25).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 2).result((ItemLike)SkiesItems.cooked_venison, 4).maxUses(10).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> SHOVELER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ToolWithFalsiteTrade(1, SkiesItems.pyrope_gem, SkiesItems.pyrope_shovel, 5, 7), new SingleTrade.Builder().item((ItemLike)SkiesItems.falsite_ingot, 8).result((ItemLike)EMERALD, 1).maxUses(8).givenXP(8).build(), new SingleTrade.Builder().item((ItemLike)SkiesItems.falsite_ingot, 4).result((ItemLike)Blocks.f_50127_, 16).givenXP(5).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ToolWithFalsiteTrade(2, SkiesItems.aquite, SkiesItems.aquite_shovel, 5, 10), new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.falsite_ingot, 3).secondItem((ItemLike)SkiesItems.aquite, 5).result((ItemLike)EMERALD, 1).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new ToolWithFalsiteTrade(3, SkiesItems.horizonite_ingot, SkiesItems.horizonite_shovel, 15, 15, 5), new StickForFalsiteTrade(1, 5, 10)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new ToolWithFalsiteTrade(5, SkiesItems.diopside_gem, SkiesItems.diopside_shovel, 5, 20, 12)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new ToolWithFalsiteTrade(10, SkiesItems.charoite, SkiesItems.charoite_shovel, 5, 25, 17)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> NIGHTWATCHER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42401_, 16).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42404_, 32).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42406_, 8).givenXP(5).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.cooked_charscale_moki, 6).givenXP(10).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42530_, 6).givenXP(10).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.cooked_horizofin_tunid, 6).givenXP(10).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.cooked_municipal_monkfish, 6).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 3).result((ItemLike)SkiesItems.aquite_helmet, 1).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 5).result((ItemLike)SkiesItems.aquite_chestplate, 1).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 4).result((ItemLike)SkiesItems.aquite_leggings, 1).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 3).result((ItemLike)SkiesItems.aquite_boots, 1).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.aquite, 6).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 4).result((ItemLike)Items.f_42676_, 1).givenXP(15).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 10).result((ItemLike)Items.f_42656_, 1).givenXP(20).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 6).result((ItemLike)Items.f_42450_, 1).givenXP(20).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42417_, 6).givenXP(20).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 8).result((ItemLike)SkiesBlocks.bag_of_spoils, 1).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> SUMMONER_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42517_, 2).givenXP(5).build(), new SingleTrade.Builder().item((ItemLike)SkiesItems.bug_guts, 32).result((ItemLike)EMERALD, 1).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)SkiesItems.pearl, 3).givenXP(13).build(), new SingleTrade.Builder().item((ItemLike)SkiesItems.soul_fragment, 22).result((ItemLike)EMERALD, 1).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)Items.f_42591_, 26).result((ItemLike)EMERALD, 1).givenXP(15).build(), new SingleTrade.Builder().item((ItemLike)Items.f_42583_, 46).result((ItemLike)EMERALD, 1).givenXP(15).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)Items.f_42648_, 6).result((ItemLike)EMERALD, 1).givenXP(25).build(), new SingleTrade.Builder().item((ItemLike)SkiesItems.fox_pelt, 22).result((ItemLike)EMERALD, 1).givenXP(20).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)SkiesItems.summoning_tome, 1).result((ItemLike)EMERALD, 6).givenXP(25).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> ALCHEMIST_OFFERS = SkiesVillagerTrades.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)EMERALD, 1).secondItem((ItemLike)Items.f_42542_, 3).result((ItemLike)Items.f_42518_, 3).build(), new SingleTrade.Builder().item((ItemLike)Items.f_42417_, 8).result((ItemLike)EMERALD, 1).givenXP(5).maxUses(5).build(), new SingleTrade.Builder().item((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42585_, 3).givenXP(5).build(), new DoubleTrade.Builder().firstItem((ItemLike)EMERALD, 1).secondItem((ItemLike)SkiesBlocks.midnight_sandstone, 16).result((ItemLike)SkiesBlocks.crystal_sandstone, 16).build(), new DoubleTrade.Builder().firstItem((ItemLike)EMERALD, 1).secondItem((ItemLike)SkiesBlocks.crystal_sandstone, 16).result((ItemLike)SkiesBlocks.midnight_sandstone, 16).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesBlocks.lunar_sapling, 1).secondItem((ItemLike)SkiesItems.crescent_fruit, 3).result((ItemLike)SkiesBlocks.crescent_fruit_sapling, 1).givenXP(10).build(), new DoubleTrade.Builder().firstItem((ItemLike)SkiesBlocks.lunar_dirt, 6).secondItem((ItemLike)SkiesItems.ventium_water_bucket, 1).result((ItemLike)SkiesBlocks.lunar_mud, 6).givenXP(5).build(), new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.camel_saddle, 1).secondItem((ItemLike)EMERALD, 1).result((ItemLike)Items.f_42450_, 1).givenXP(10).build(), new DoubleTrade.Builder().firstItem((ItemLike)SkiesItems.horizonite_ingot, 3).secondItem((ItemLike)SkiesItems.ventium_water_bucket, 1).result((ItemLike)Items.f_42416_, 3).givenXP(10).maxUses(15).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)Items.f_42446_, 1).result((ItemLike)SkiesItems.ventium_bucket, 1).maxUses(3).givenXP(10).build(), new DoubleTrade.Builder().firstItem((ItemLike)SkiesBlocks.lunar_planks, 16).secondItem((ItemLike)SkiesBlocks.moonstone_crystal, 4).result((ItemLike)SkiesBlocks.crystallized_planks, 16).givenXP(17).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new DoubleTrade.Builder().firstItem((ItemLike)SkiesBlocks.lunar_grass, 12).secondItem((ItemLike)SkiesItems.moonstone_shard, 6).result((ItemLike)SkiesBlocks.crystallized_grass, 12).givenXP(15).build(), new DoubleTrade.Builder().firstItem((ItemLike)EMERALD, 15).secondItem((ItemLike)SkiesItems.ventium_water_bucket, 1).result((ItemLike)SkiesItems.ventium_lava_bucket, 1).givenXP(15).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new SingleTrade.Builder().item((ItemLike)SkiesItems.alchemy_scroll, 1).result((ItemLike)EMERALD, 6).givenXP(25).build()}));
    public static final VillagerTrades.ItemListing BLINDING_DUNGEON_OFFER = new EmeraldForMapTrade("blinding_dungeon", 8, SkiesStructureTags.ON_BLINDING_MAPS, MapDecoration.Type.RED_X, 15, 5);
    public static final VillagerTrades.ItemListing NATURE_DUNGEON_OFFER = new EmeraldForMapTrade("nature_dungeon", 12, SkiesStructureTags.ON_NATURE_MAPS, MapDecoration.Type.RED_X, 15, 5);
    public static final VillagerTrades.ItemListing POISON_DUNGEON_OFFER = new EmeraldForMapTrade("poison_dungeon", 12, SkiesStructureTags.ON_POISON_MAPS, MapDecoration.Type.RED_X, 15, 5);

    public static Int2ObjectMap<VillagerTrades.ItemListing[]> getAsIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> tradeList) {
        return new Int2ObjectOpenHashMap(tradeList);
    }

    public static class DoubleTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack itemGiven1;
        private final int itemGiven1Count;
        private final ItemStack itemGiven2;
        private final int itemGiven2Count;
        private final ItemStack itemSold;
        private final int soldItemCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;
        private final ResourceLocation allowedDim;

        public DoubleTrade(Item itemGiven1, int itemGiven1Count, Item itemGiven2, int itemGiven2Count, Item soldItem, int soldItemCount, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this(new ItemStack((ItemLike)itemGiven1), itemGiven1Count, new ItemStack((ItemLike)itemGiven2), itemGiven2Count, new ItemStack((ItemLike)soldItem), soldItemCount, maxUsesIn, givenXPIn, allowedDim);
        }

        public DoubleTrade(ItemStack itemGiven1In, int itemGiven1CountIn, ItemStack itemGiven2In, int itemGiven2CountIn, ItemStack itemSoldIn, int itemSoldCountIn, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this.itemGiven1 = itemGiven1In;
            this.itemGiven1Count = itemGiven1CountIn;
            this.itemGiven2 = itemGiven2In;
            this.itemGiven2Count = itemGiven2CountIn;
            this.itemSold = itemSoldIn;
            this.soldItemCount = itemSoldCountIn;
            this.maxUses = maxUsesIn;
            this.givenXP = givenXPIn;
            this.priceMultiplier = 0.05f;
            this.allowedDim = allowedDim;
        }

        public MerchantOffer m_5670_(Entity entity, Random rand) {
            if (this.allowedDim != null && !entity.f_19853_.m_46472_().m_135782_().equals((Object)this.allowedDim)) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)this.itemGiven1.m_41720_(), this.itemGiven1Count), new ItemStack((ItemLike)this.itemGiven2.m_41720_(), this.itemGiven2Count), new ItemStack((ItemLike)this.itemSold.m_41720_(), this.soldItemCount), this.maxUses, this.givenXP, this.priceMultiplier);
        }

        public static class Builder {
            private Item itemGiven1 = Items.f_42405_;
            private int itemGiven1Count = 1;
            private Item itemGiven2 = EMERALD;
            private int itemGiven2Count = 1;
            private Item itemSold = Items.f_42406_;
            private int itemSoldCount = 1;
            private int maxUses = 12;
            private int givenXP = 3;
            private ResourceLocation allowedDim = null;

            public Builder firstItem(ItemLike item, int count) {
                this.itemGiven1 = item.m_5456_();
                this.itemGiven1Count = count;
                return this;
            }

            public Builder secondItem(ItemLike item, int count) {
                this.itemGiven2 = item.m_5456_();
                this.itemGiven2Count = count;
                return this;
            }

            public Builder result(ItemLike item, int count) {
                this.itemSold = item.m_5456_();
                this.itemSoldCount = count;
                return this;
            }

            public Builder maxUses(int maxUses) {
                this.maxUses = maxUses;
                return this;
            }

            public Builder givenXP(int givenXp) {
                this.givenXP = givenXp;
                return this;
            }

            public Builder allowedDim(ResourceLocation dim) {
                this.allowedDim = dim;
                return this;
            }

            public DoubleTrade build() {
                return new DoubleTrade(this.itemGiven1, this.itemGiven1Count, this.itemGiven2, this.itemGiven2Count, this.itemSold, this.itemSoldCount, this.maxUses, this.givenXP, this.allowedDim);
            }
        }
    }

    public static class SingleTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack itemGiven1;
        private final int itemGiven1Count;
        private final ItemStack itemSold;
        private final int soldItemCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;
        private final ResourceLocation allowedDim;

        public SingleTrade(Item itemGiven1, int itemGiven1Count, Item soldItem, int soldItemCount, int maxUses, int givenXP, ResourceLocation allowedDim) {
            this(new ItemStack((ItemLike)itemGiven1), itemGiven1Count, new ItemStack((ItemLike)soldItem), soldItemCount, maxUses, givenXP, allowedDim);
        }

        public SingleTrade(ItemStack itemGiven1In, int itemGiven1CountIn, ItemStack itemSoldIn, int itemSoldCountIn, int maxUsesIn, int givenXPIn, ResourceLocation allowedDim) {
            this.itemGiven1 = itemGiven1In;
            this.itemGiven1Count = itemGiven1CountIn;
            this.itemSold = itemSoldIn;
            this.soldItemCount = itemSoldCountIn;
            this.maxUses = maxUsesIn;
            this.givenXP = givenXPIn;
            this.priceMultiplier = 0.05f;
            this.allowedDim = allowedDim;
        }

        public MerchantOffer m_5670_(Entity entity, Random rand) {
            if (this.allowedDim != null && !entity.f_19853_.m_46472_().m_135782_().equals((Object)this.allowedDim)) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)this.itemGiven1.m_41720_(), this.itemGiven1Count), new ItemStack((ItemLike)this.itemSold.m_41720_(), this.soldItemCount), this.maxUses, this.givenXP, this.priceMultiplier);
        }

        public static class Builder {
            private Item itemGiven1 = EMERALD;
            private int itemGiven1Count = 1;
            private Item itemSold = Items.f_42406_;
            private int itemSoldCount = 1;
            private int maxUses = 12;
            private int givenXP = 3;
            private ResourceLocation allowedDim = null;

            public Builder item(ItemLike item, int count) {
                this.itemGiven1 = item.m_5456_();
                this.itemGiven1Count = count;
                return this;
            }

            public Builder result(ItemLike item, int count) {
                this.itemSold = item.m_5456_();
                this.itemSoldCount = count;
                return this;
            }

            public Builder maxUses(int maxUses) {
                this.maxUses = maxUses;
                return this;
            }

            public Builder givenXP(int givenXp) {
                this.givenXP = givenXp;
                return this;
            }

            public Builder allowedDim(ResourceLocation dim) {
                this.allowedDim = dim;
                return this;
            }

            public SingleTrade build() {
                return new SingleTrade(this.itemGiven1, this.itemGiven1Count, this.itemSold, this.itemSoldCount, this.maxUses, this.givenXP, this.allowedDim);
            }
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ItemListing {
        private final String displayName;
        private final int count;
        private final TagKey<ConfiguredStructureFeature<?, ?>> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(String displayName, int count, TagKey<ConfiguredStructureFeature<?, ?>> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.displayName = displayName;
            this.count = count;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)trader.f_19853_;
            BlockPos blockpos = serverlevel.m_207561_(this.structureName, trader.m_142538_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + BlueSkies.find(this.displayName)));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.count), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }

    static class ToolWithFalsiteTrade
    implements VillagerTrades.ItemListing {
        private final int count;
        private final Item toolMaterial;
        private final Item toolItem;
        private final int maxUses;
        private final int xpValue;
        private final int enchantLevel;

        public ToolWithFalsiteTrade(int emeraldCount, Item toolMaterial, Item toolItem, int maxUses, int xpValue, int enchantLevel) {
            this.count = emeraldCount;
            this.toolMaterial = toolMaterial;
            this.toolItem = toolItem;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.enchantLevel = enchantLevel;
        }

        public ToolWithFalsiteTrade(int emeraldCount, Item toolMaterial, Item toolItem, int maxUses, int xpValue) {
            this(emeraldCount, toolMaterial, toolItem, maxUses, xpValue, 0);
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((ItemLike)this.toolItem);
            ArrayList stickList = trader.f_19853_.m_46472_().equals(SkiesDimensions.everbrightKey()) ? EVERBRIGHT_STICKS : (trader.f_19853_.m_46472_().equals(SkiesDimensions.everdawnKey()) ? EVERDAWN_STICKS : Lists.newArrayList((Object[])new Item[]{Items.f_42398_}));
            ToolUtils.setStickType(itemstack, stickList.get(rand.nextInt(stickList.size())));
            IFalsiteItem.applyFalsite(itemstack);
            if (this.enchantLevel > 0) {
                EnchantmentHelper.m_44877_((Random)rand, (ItemStack)itemstack, (int)this.enchantLevel, (boolean)false);
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.count), new ItemStack((ItemLike)this.toolMaterial), itemstack, this.maxUses, this.xpValue, 0.2f);
        }
    }

    static class StickForFalsiteTrade
    implements VillagerTrades.ItemListing {
        private final int count;
        private final int maxUses;
        private final int xpValue;

        public StickForFalsiteTrade(int falsiteCount, int maxUses, int xpValue) {
            this.count = falsiteCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ArrayList stickList = trader.f_19853_.m_46472_().equals(SkiesDimensions.everbrightKey()) ? EVERBRIGHT_STICKS : (trader.f_19853_.m_46472_().equals(SkiesDimensions.everdawnKey()) ? EVERDAWN_STICKS : Lists.newArrayList((Object[])new Item[]{Items.f_42398_}));
            return new MerchantOffer(new ItemStack((ItemLike)stickList.get(rand.nextInt(stickList.size())), 32), new ItemStack((ItemLike)SkiesItems.falsite_ingot, this.count), this.maxUses, this.xpValue, 0.2f);
        }
    }

    public static class KeyTrade
    extends DoubleTrade {
        public KeyTrade(Item itemGiven1, int itemGiven1Count, Item itemGiven2, int itemGiven2Count, Item key) {
            super(itemGiven1, itemGiven1Count, itemGiven2, itemGiven2Count, key, 1, 4, 1, null);
        }
    }
}

