/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive.fish;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.util.interfaces.IVentiumCatchable;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class JellyDrifterEntity
extends WaterAnimal
implements IVentiumCatchable {
    private static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.m_135353_(JellyDrifterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(JellyDrifterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float jellyPitch;
    public float prevJellyPitch;
    public float jellyYaw;
    public float prevJellyYaw;

    public JellyDrifterEntity(EntityType<? extends JellyDrifterEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 80));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public boolean m_8023_() {
        return this.isFromBucket();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.m_8077_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevJellyPitch = this.jellyPitch;
        this.prevJellyYaw = this.jellyYaw;
        if (this.m_20072_()) {
            Vec3 vector3d = this.m_20184_();
            double f1 = vector3d.m_165924_();
            this.f_20883_ += (-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.jellyYaw = (float)((double)this.jellyYaw + 2.356194490192345);
            this.jellyPitch += (-((float)Mth.m_14136_((double)f1, (double)vector3d.f_82480_)) * 57.295776f - this.jellyPitch) * 0.1f;
        } else {
            this.jellyPitch = 0.0f;
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag != null && dataTag.m_128425_("Color", 99)) {
            this.setColor(dataTag.m_128445_("Color"));
        } else {
            this.setColor(Colors.getRandom(this.f_19796_).getId());
        }
        return spawnDataIn;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Color", this.getColor());
        compound.m_128379_("FromBucket", this.isFromBucket());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setColor(compound.m_128445_("Color"));
        this.setFromVentiumBucket(compound.m_128471_("FromBucket"));
    }

    public void setColor(byte color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public byte getColor() {
        return (Byte)this.f_19804_.m_135370_(COLOR);
    }

    public boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void setFromVentiumBucket(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_JELLY_DRIFTER_DEATH;
    }

    protected float m_6121_() {
        return 0.7f;
    }

    @Override
    public ItemStack getVentiumBucket() {
        return new ItemStack((ItemLike)SkiesItems.ventium_drifter_bucket);
    }

    protected void m_7324_(Entity entityIn) {
        super.m_7324_(entityIn);
        if (entityIn instanceof LivingEntity && !(entityIn instanceof JellyDrifterEntity) && !((LivingEntity)entityIn).m_21023_(MobEffects.f_19614_) && !entityIn.m_20147_()) {
            if (entityIn instanceof Player && ((Player)entityIn).m_7500_()) {
                return;
            }
            if (!this.f_19853_.f_46443_) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
                this.m_5496_(SkiesSounds.ENTITY_JELLY_DRIFTER_POISON, 1.0f, this.m_6100_());
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack waterBucket = player.m_21120_(hand);
        if (waterBucket.m_41720_() == SkiesItems.ventium_water_bucket && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            waterBucket.m_41774_(1);
            ItemStack bucket = this.getVentiumBucket();
            this.setBucketData(bucket);
            if (!this.f_19853_.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucket);
            }
            if (waterBucket.m_41619_()) {
                player.m_21008_(hand, bucket);
            } else if (!player.m_150109_().m_36054_(bucket)) {
                player.m_36176_(bucket, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128344_("Color", this.getColor());
    }

    public static boolean spawnConditions(EntityType<? extends JellyDrifterEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223363_3_, Random randomIn) {
        return worldIn.m_8055_(p_223363_3_).m_60734_() == Blocks.f_49990_ && worldIn.m_8055_(p_223363_3_.m_7494_()).m_60734_() == Blocks.f_49990_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final JellyDrifterEntity jellyfish;

        MoveHelperController(JellyDrifterEntity fish) {
            super((Mob)fish);
            this.jellyfish = fish;
        }

        public void m_8126_() {
            if (this.jellyfish.m_204029_(FluidTags.f_13131_)) {
                this.jellyfish.m_20256_(this.jellyfish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.jellyfish.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.jellyfish.m_20185_();
                double d1 = this.f_24976_ - this.jellyfish.m_20186_();
                double d2 = this.f_24977_ - this.jellyfish.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.jellyfish.m_146922_(this.m_24991_(this.jellyfish.m_146908_(), f, 90.0f));
                this.jellyfish.f_20883_ = this.jellyfish.m_146908_();
                float f1 = (float)(this.f_24978_ * this.jellyfish.m_21051_(Attributes.f_22279_).m_22135_());
                this.jellyfish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.jellyfish.m_6113_(), (float)f1));
                this.jellyfish.m_20256_(this.jellyfish.m_20184_().m_82520_(0.0, (double)this.jellyfish.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.jellyfish.m_7910_(0.0f);
            }
        }
    }

    public static enum Colors {
        SNOW,
        ICY,
        ROSE,
        TEAL,
        AMBER,
        CRIMSON;

        private final ResourceLocation texture = BlueSkies.locate(String.format("textures/entity/jelly_drifter/jelly_drifter_%s.png", StringUtil.toLower(this.name())));

        public byte getId() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static Colors getRandom(Random rand) {
            return rand.nextFloat() < 0.002f ? CRIMSON : Colors.values()[rand.nextInt(Colors.values().length - 1)];
        }

        public static Colors byId(int id) {
            if (id < 0 || id >= Colors.values().length) {
                id = 0;
            }
            return Colors.values()[id];
        }
    }
}

